/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.institution;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.institution.InstitutionEndpoint;
import aa.aggregators.institution.SAMLMapping;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class InstitutionAttributeAggregator
extends AbstractAttributeAggregator {
    private final Map<String, InstitutionEndpoint> institutionServicesConfig;
    private final SAMLMapping samlMapping = new SAMLMapping();

    public InstitutionAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration, Resource serviceProviderConfigPath, ObjectMapper objectMapper) {
        super(attributeAuthorityConfiguration);
        Map config = (Map)objectMapper.readValue(serviceProviderConfigPath.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.institutionServicesConfig = config.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> new InstitutionEndpoint((String)((Map)entry.getValue()).get("baseUrl"), (String)((Map)entry.getValue()).get("userName"), (String)((Map)entry.getValue()).get("password"))));
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        Map body;
        String spEntityID = (String)input.stream().filter(userAttribute -> userAttribute.getName().equals("SPentityID")).findFirst().get().getValues().getFirst();
        InstitutionEndpoint institutionEndpoint = (InstitutionEndpoint)this.institutionServicesConfig.get(spEntityID);
        if (institutionEndpoint == null) {
            this.LOG.error("No InstitutionEndpoint configured for: {}", (Object)spEntityID);
            return this.errorResponse(input);
        }
        RestTemplate restTemplate = super.initializeRestTemplate(super.getAttributeAuthorityConfiguration());
        BasicAuthenticationInterceptor interceptor = new BasicAuthenticationInterceptor(institutionEndpoint.getUserName(), institutionEndpoint.getPassword());
        restTemplate.getInterceptors().add(interceptor);
        String eduID = (String)input.stream().filter(attribute -> attribute.getName().equals("urn:mace:eduid.nl:1.1")).findFirst().get().getValues().getFirst();
        String url = String.format("%s/api/attributes/%s", this.removeTrailingSlash(institutionEndpoint.getBaseURL()), eduID);
        try {
            body = (Map)restTemplate.getForEntity(url, Map.class, new Object[0]).getBody();
        }
        catch (RuntimeException e) {
            String msg = String.format("InstitutionEndpoint %s configured for: %s, returned an error %s", institutionEndpoint, spEntityID, e);
            if (e instanceof HttpStatusCodeException && ((HttpStatusCodeException)((Object)e)).getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                this.LOG.info(msg);
            } else {
                this.LOG.error(msg, (Throwable)e);
            }
            return this.errorResponse(input);
        }
        this.LOG.debug("Received response {} from {} for SP {}", new Object[]{body, institutionEndpoint.getBaseURL(), spEntityID});
        List<String> institutionAttributeNames = arpAttributes.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(arpValue -> arpValue.getSource().equals(super.getAttributeAuthorityId()))).map(entry -> (String)entry.getKey()).toList();
        ArrayList<UserAttribute> result = new ArrayList<UserAttribute>();
        institutionAttributeNames.forEach(samlAttributeName -> {
            Optional optionalName = this.samlMapping.convertSAMLAttributeName(samlAttributeName);
            if (optionalName.isPresent()) {
                List values = (List)body.get(optionalName.get());
                if (!CollectionUtils.isEmpty((Collection)values)) {
                    result.add(new UserAttribute(samlAttributeName, values, super.getAttributeAuthorityId()));
                } else {
                    input.stream().filter(userAttribute -> userAttribute.getName().equals(samlAttributeName)).findFirst().ifPresent(userAttribute -> result.add(new UserAttribute(samlAttributeName, userAttribute.getValues(), super.getAttributeAuthorityId())));
                }
            }
        });
        return result;
    }

    private String removeTrailingSlash(String baseURL) {
        if (baseURL.endsWith("/")) {
            return baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL;
    }

    private List<UserAttribute> errorResponse(List<UserAttribute> userAttributesInput) {
        return userAttributesInput.stream().map(userAttribute -> new UserAttribute(userAttribute.getName(), userAttribute.getValues(), super.getAttributeAuthorityId())).toList();
    }
}

