/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators;

import aa.aggregators.AttributeAggregator;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.Cache;
import aa.model.RequiredInputAttribute;
import aa.model.UserAttribute;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractAttributeAggregator
implements AttributeAggregator {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final AttributeAuthorityConfiguration attributeAuthorityConfiguration;
    private final List<String> attributeKeysRequired;
    private RestTemplate restTemplate;

    public AbstractAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        this.attributeAuthorityConfiguration = attributeAuthorityConfiguration;
        this.attributeKeysRequired = attributeAuthorityConfiguration.getRequiredInputAttributes().stream().map(RequiredInputAttribute::getName).collect(Collectors.toList());
        if (StringUtils.hasText((String)attributeAuthorityConfiguration.getEndpoint())) {
            this.restTemplate = this.initializeRestTemplate(attributeAuthorityConfiguration);
        }
    }

    protected RestTemplate initializeRestTemplate(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        RestTemplate restTemplate = new RestTemplate(this.getRequestFactory(attributeAuthorityConfiguration));
        if (StringUtils.hasText((String)attributeAuthorityConfiguration.getUser())) {
            BasicAuthenticationInterceptor interceptor = new BasicAuthenticationInterceptor(attributeAuthorityConfiguration.getUser(), attributeAuthorityConfiguration.getPassword());
            restTemplate.getInterceptors().add(interceptor);
        }
        return restTemplate;
    }

    public List<String> attributeKeysRequired() {
        return this.attributeKeysRequired;
    }

    public Optional<String> cacheKey(List<UserAttribute> input) {
        List requiredKeys = this.attributeKeysRequired();
        Set values = input.stream().filter(userAttribute -> requiredKeys.contains(userAttribute.getName())).map(UserAttribute::getValues).flatMap(Collection::stream).collect(Collectors.toSet());
        return values.isEmpty() ? Optional.empty() : Optional.of(this.getAttributeAuthorityId() + "-" + String.join((CharSequence)",", values));
    }

    public String getAttributeAuthorityId() {
        return this.attributeAuthorityConfiguration.getId();
    }

    protected URI endpoint() {
        return this.endpoint("");
    }

    protected URI endpoint(String postPath) {
        try {
            return new URI(this.attributeAuthorityConfiguration.getEndpoint() + postPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getUserAttributeSingleValue(List<UserAttribute> input, String nameId) {
        Optional<UserAttribute> userAttribute = input.stream().filter(attr -> attr.getName().equals(nameId)).findFirst();
        if (!userAttribute.isPresent() || userAttribute.get().getValues().isEmpty()) {
            throw new IllegalArgumentException(String.format("%s requires %s attribute with value", this.getClass(), nameId));
        }
        return (String)userAttribute.get().getValues().get(0);
    }

    protected List<UserAttribute> mapValuesToUserAttribute(String attributeName, List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new UserAttribute(attributeName, values.stream().sorted().collect(Collectors.toList()), this.getAttributeAuthorityId()));
    }

    private ClientHttpRequestFactory getRequestFactory(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setTimeToLive(60L, TimeUnit.SECONDS).build();
        PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).disableCookieManagement().build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectionRequestTimeout(10000);
        int timeOut = attributeAuthorityConfiguration.getTimeOut();
        requestFactory.setConnectTimeout(timeOut);
        requestFactory.setReadTimeout(timeOut);
        return requestFactory;
    }

    public String toString() {
        return String.format("AttributeAggregator with configuration: %s", this.attributeAuthorityConfiguration);
    }

    public List<UserAttribute> filterInvalidResponses(List<UserAttribute> input) {
        String validationRegExp = this.attributeAuthorityConfiguration.getValidationRegExp();
        Pattern pattern = Pattern.compile(validationRegExp, 2);
        return input.stream().map(userAttribute -> new UserAttribute(userAttribute.getName(), userAttribute.getValues().stream().filter(value -> this.filterAttributeValue(userAttribute, value, pattern)).collect(Collectors.toList()), userAttribute.getSource())).filter(userAttribute -> !CollectionUtils.isEmpty((Collection)userAttribute.getValues())).collect(Collectors.toList());
    }

    protected String encode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private boolean filterAttributeValue(UserAttribute userAttribute, String value, Pattern pattern) {
        boolean result = pattern.matcher(value).matches();
        if (!result) {
            this.LOG.warn("Filtered out invalid value {} for userAttribute {} based on pattern {}", new Object[]{value, userAttribute, pattern});
        }
        return result;
    }

    public boolean cachingEnabled() {
        Cache cacheConfig = this.attributeAuthorityConfiguration.getCache();
        return null != cacheConfig && Boolean.TRUE.equals(cacheConfig.getEnabled());
    }

    @Generated
    public AttributeAuthorityConfiguration getAttributeAuthorityConfiguration() {
        return this.attributeAuthorityConfiguration;
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

