/*
 * Decompiled with CFR 0.152.
 */
package aa.service;

import aa.aggregators.AttributeAggregator;
import aa.cache.UserAttributeCache;
import aa.config.AuthorityConfiguration;
import aa.model.ArpAggregationRequest;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AttributeAggregatorService {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeAggregatorService.class);
    private static final Logger ANALYTICS_LOG = LoggerFactory.getLogger((String)"analytics");
    private final Map<String, AttributeAggregator> aggregators;
    private final ForkJoinPool forkJoinPool;
    private final AuthorityConfiguration configuration;
    private final UserAttributeCache cache;

    public AttributeAggregatorService(List<AttributeAggregator> aggregators, AuthorityConfiguration configuration, UserAttributeCache cache) {
        Assert.notEmpty(aggregators, (String)"Aggregators must not be empty");
        this.aggregators = aggregators.stream().collect(Collectors.toMap(AttributeAggregator::getAttributeAuthorityId, Function.identity()));
        this.forkJoinPool = new ForkJoinPool(20 * aggregators.size());
        this.configuration = configuration;
        this.cache = cache;
    }

    public List<UserAttribute> aggregateBasedOnArp(ArpAggregationRequest arpAggregationRequest) {
        long start = System.currentTimeMillis();
        ANALYTICS_LOG.info("Started to aggregate attributes based on ARP for input {}", (Object)arpAggregationRequest);
        Set sources = arpAggregationRequest.getArpAttributes().values().stream().flatMap(arpValues -> arpValues.stream().map(ArpValue::getSource)).collect(Collectors.toSet());
        List authorities = this.configuration.getAuthorities().stream().filter(conf -> sources.contains(conf.getId())).collect(Collectors.toList());
        List aggregatedAttributes = this.getUserAttributes(arpAggregationRequest.getUserAttributes(), arpAggregationRequest.getArpAttributes(), authorities);
        ANALYTICS_LOG.info("All aggregating attributes based on ARP input {} with result {}", (Object)arpAggregationRequest, (Object)aggregatedAttributes);
        List<UserAttribute> filteredUserAttributes = aggregatedAttributes.stream().map(userAttribute -> {
            List arpValues = arpAggregationRequest.getArpAttributes().getOrDefault(userAttribute.getName(), Collections.emptyList());
            List allowedValues = arpValues.stream().filter(arpValue -> userAttribute.getSource().equals(arpValue.getSource())).map(ArpValue::getValue).collect(Collectors.toList());
            List filteredValues = userAttribute.getValues().stream().filter(value -> this.valueAllowed(value, allowedValues)).collect(Collectors.toList());
            return filteredValues.isEmpty() ? Optional.empty() : Optional.of(new UserAttribute(userAttribute.getName(), filteredValues, userAttribute.getSource()));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        ANALYTICS_LOG.info("Finished aggregating and filtering attributes based on ARP in {} millis for input {} with result {}", new Object[]{System.currentTimeMillis() - start, arpAggregationRequest, filteredUserAttributes});
        return filteredUserAttributes;
    }

    private boolean valueAllowed(String value, List<String> arpValues) {
        return arpValues.stream().anyMatch(arpValue -> arpValue.equals("*") || arpValue.equalsIgnoreCase(value) || arpValue.endsWith("*") && value.startsWith(arpValue.substring(0, arpValue.length() - 1)));
    }

    private List<UserAttribute> getUserAttributes(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes, Collection<AttributeAuthorityConfiguration> authorityConfigurations) {
        List inputNames = input.stream().filter(userAttribute -> userAttribute.getValues().stream().anyMatch(StringUtils::hasText)).map(UserAttribute::getName).collect(Collectors.toList());
        List attributeAggregators = authorityConfigurations.stream().map(attributeAuthority -> (AttributeAggregator)this.aggregators.get(attributeAuthority.getId())).filter(attributeAggregator -> inputNames.containsAll(attributeAggregator.attributeKeysRequired())).collect(Collectors.toList());
        try {
            return (List)((ForkJoinTask)this.forkJoinPool.submit(() -> attributeAggregators.parallelStream().map(aggregator -> this.doAggregate(input, aggregator, arpAttributes)).flatMap(Collection::stream).collect(Collectors.toList()))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to schedule querying of attribute aggregators.", e);
        }
    }

    private List<UserAttribute> doAggregate(List<UserAttribute> input, AttributeAggregator aggregator, Map<String, List<ArpValue>> arpAttributes) {
        try {
            Optional cacheKey = aggregator.cacheKey(input);
            Optional userAttributesFromCache = this.cache.get(cacheKey);
            if (userAttributesFromCache.isPresent()) {
                return (List)userAttributesFromCache.get();
            }
            List userAttributes = aggregator.aggregate(input, arpAttributes);
            List filteredAttributes = aggregator.filterInvalidResponses(userAttributes);
            this.cache.put(cacheKey, filteredAttributes);
            return filteredAttributes;
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("AttributeAggregator {} threw exception: {} ", (Object)aggregator.getAttributeAuthorityId(), (Object)e);
            return Collections.emptyList();
        }
    }
}

