/*
 * Decompiled with CFR 0.152.
 */
package dashboard.stats;

import com.google.common.collect.ImmutableList;
import dashboard.control.Constants;
import dashboard.stats.Stats;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class StatsImpl
implements Stats,
Constants {
    private final RestTemplate restTemplate = new RestTemplate(this.clientHttpRequestFactory(10000));
    private final String baseUrl;

    public StatsImpl(@Value(value="${statsUser}") String user, @Value(value="${statsPassword}") String password, @Value(value="${statsBaseUrl}") String baseUrl) {
        this.baseUrl = baseUrl;
        this.restTemplate.setInterceptors((List)ImmutableList.of((request, body, execution) -> {
            HttpHeaders headers = request.getHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept((List)ImmutableList.of((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", this.authorizationHeaderValue(user, password));
            return execution.execute(request, body);
        }));
    }

    public List<Object> loginTimeFrame(long from, long to, String scale, Optional<String> spEntityIdOptional) {
        String idp = this.currentIdPEncoded();
        StringBuilder url = new StringBuilder(String.format("%s/public/login_time_frame?from=%s&to=%s&include_unique=true&scale=%s&epoch=ms&idp_id=%s", this.baseUrl, from, to, scale, idp));
        spEntityIdOptional.ifPresent(spEntityId -> url.append(String.format("&sp_id=%s", spEntityId)));
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    private String currentIdPEncoded() {
        return URLEncoder.encode(this.currentUserIdp(), Charset.defaultCharset());
    }

    public List<Object> loginAggregated(String period, Optional<String> spEntityIdOptional) {
        String idp = this.currentIdPEncoded();
        StringBuilder url = new StringBuilder(String.format("%s/public/login_aggregated?period=%s&include_unique=true&idp_id=%s&group_by=sp_id", this.baseUrl, period, idp));
        spEntityIdOptional.ifPresent(spEntityId -> url.append(String.format("&sp_id=%s", spEntityId)));
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    public List<Object> uniqueLoginCount(long from, long to, String spEntityId) {
        String idp = this.currentIdPEncoded();
        String url = String.format("%s/public/unique_login_count?from=%s&to=%s&include_unique=true&epoch=ms&idp_id=%s&sp_id=%s", this.baseUrl, from, to, idp, spEntityId);
        return (List)this.restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }
}

