/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.collect.ImmutableList;
import dashboard.domain.CoinUser;
import dashboard.domain.IdentityProvider;
import dashboard.util.SpringSecurity;
import java.util.Base64;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public interface Constants {
    public static final String HTTP_X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";
    public static final String X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";
    public static final String X_UNSPECIFIED_NAME_ID = "X-UNSPECIFIED-NAME-ID";
    public static final String X_DISPLAY_NAME = "X-DISPLAY-NAME";

    default public ClientHttpRequestFactory clientHttpRequestFactory(int timeout) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setReadTimeout(timeout);
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setHttpClient((HttpClient)HttpClients.custom().disableCookieManagement().build());
        return requestFactory;
    }

    default public ClientHttpRequestInterceptor clientHttpRequestInterceptor(String username, String password) {
        return (request, body, execution) -> {
            CoinUser user = SpringSecurity.getCurrentUser();
            IdentityProvider idp = user.getSwitchedToIdp().orElse(user.getIdp());
            HttpHeaders headers = request.getHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept((List)ImmutableList.of((Object)MediaType.APPLICATION_JSON));
            headers.set("Authorization", this.authorizationHeaderValue(username, password));
            headers.set("X-IDP-ENTITY-ID", idp.getId());
            headers.set(X_UNSPECIFIED_NAME_ID, user.getUid());
            headers.set(X_DISPLAY_NAME, user.getDisplayName());
            return execution.execute(request, body);
        };
    }

    default public String authorizationHeaderValue(String username, String password) {
        return "Basic " + new String(Base64.getEncoder().encode(String.format("%s:%s", username, password).getBytes()));
    }

    default public String currentUserIdp() {
        CoinUser user = SpringSecurity.getCurrentUser();
        IdentityProvider idp = user.getSwitchedToIdp().orElse(user.getIdp());
        return idp.getId();
    }
}

