/*
 * Decompiled with CFR 0.152.
 */
package dashboard.pdp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import dashboard.control.Constants;
import dashboard.domain.Attribute;
import dashboard.domain.Policy;
import dashboard.pdp.PdpService;
import dashboard.pdp.PolicyNameNotUniqueException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class PdpServiceImpl
implements PdpService,
Constants {
    private static final Logger LOG = LoggerFactory.getLogger(PdpServiceImpl.class);
    private final RestTemplate pdpRestTemplate;
    private final String server;
    private final ObjectMapper objectMapper;

    public PdpServiceImpl(ObjectMapper objectMapper, String server, String username, String password) {
        Preconditions.checkArgument((boolean)server.startsWith("http"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)username) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0);
        this.pdpRestTemplate = new RestTemplate(this.clientHttpRequestFactory(10000));
        this.pdpRestTemplate.getInterceptors().add(this.clientHttpRequestInterceptor(username, password));
        this.server = server;
        this.objectMapper = objectMapper;
    }

    public boolean isAvailable() {
        try {
            Set options = this.pdpRestTemplate.optionsForAllow(this.buildUri("/protected/policies"));
            return options.contains(HttpMethod.GET) && !options.contains(HttpMethod.PATCH);
        }
        catch (RestClientException e) {
            LOG.warn("PDP protected api was not available", (Throwable)e);
            return false;
        }
    }

    public List<Policy> policies() {
        RequestEntity request = this.buildGetRequest("/protected/policies");
        return (List)this.executeWithExceptionLogging(() -> (List)this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody());
    }

    public Policy policy(Object id) {
        RequestEntity request = this.buildGetRequest("/protected/policies/" + String.valueOf(id));
        return (Policy)this.executeWithExceptionLogging(() -> (Policy)this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody());
    }

    public Policy create(Policy policy) {
        RequestEntity request = this.buildPostRequest("/protected/policies", (Object)policy);
        try {
            try {
                String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)policy);
                LOG.info("creation of policy {}", (Object)json);
            }
            catch (IOException e) {
                LOG.error("Unexpected error from PdP", (Throwable)e);
            }
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (Policy)response.getBody();
        }
        catch (HttpStatusCodeException sce) {
            String response;
            if (sce.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST) && ((response = sce.getResponseBodyAsString()).contains("unique") || response.contains("DuplicateEntityIdException"))) {
                throw new PolicyNameNotUniqueException(response);
            }
            LOG.error("Response error: {} {}:\n {}", new Object[]{sce.getStatusCode(), sce.getStatusText(), sce.getResponseBodyAsString()});
            throw new RuntimeException(sce);
        }
    }

    public Policy update(Policy policy) {
        RequestEntity request = this.buildPutRequest("/protected/policies", (Object)policy);
        return (Policy)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (Policy)response.getBody();
        });
    }

    public ResponseEntity<String> delete(Object id) {
        RequestEntity request = this.buildDeleteRequest("/protected/policies/" + String.valueOf(id));
        return (ResponseEntity)this.executeWithExceptionLogging(() -> this.pdpRestTemplate.exchange(request, String.class));
    }

    public List<Policy> revisions(Object id) {
        RequestEntity request = this.buildGetRequest("/protected/revisions/" + String.valueOf(id));
        return (List)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (List)response.getBody();
        });
    }

    public List<Attribute> allowedAttributes() {
        RequestEntity request = this.buildGetRequest("/protected/attributes/");
        return (List)this.executeWithExceptionLogging(() -> {
            ResponseEntity response = this.pdpRestTemplate.exchange(request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return ((List)response.getBody()).stream().map(aa -> new Attribute(aa.attributeId, aa.value)).collect(Collectors.toList());
        });
    }

    private <T> T executeWithExceptionLogging(Supplier<T> makeRequest) {
        try {
            return makeRequest.get();
        }
        catch (HttpStatusCodeException sce) {
            LOG.error("Response error: {} {}:\n {}", new Object[]{sce.getStatusCode(), sce.getStatusText(), sce.getResponseBodyAsString()});
            throw new RuntimeException(sce);
        }
    }

    private RequestEntity<?> buildDeleteRequest(String path) {
        return RequestEntity.delete((URI)this.buildUri(path)).build();
    }

    private RequestEntity<?> buildPostRequest(String path, Object body) {
        return RequestEntity.post((URI)this.buildUri(path)).body(body);
    }

    private RequestEntity<?> buildPutRequest(String path, Object body) {
        return RequestEntity.put((URI)this.buildUri(path)).body(body);
    }

    private RequestEntity<?> buildGetRequest(String path) {
        return RequestEntity.get((URI)this.buildUri(path)).build();
    }

    protected URI buildUri(String path) {
        Preconditions.checkArgument((boolean)path.startsWith("/"));
        return URI.create(String.format("%s/pdp/api%s", this.server, path));
    }

    protected RestTemplate getPdpRestTemplate() {
        return this.pdpRestTemplate;
    }
}

