/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import dashboard.domain.Action;
import dashboard.domain.ContactPerson;
import dashboard.domain.ContactPersonType;
import dashboard.domain.JiraFilter;
import dashboard.domain.JiraResponse;
import dashboard.domain.Provider;
import dashboard.domain.ServiceProvider;
import dashboard.mail.MailBox;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.service.ActionsService;
import dashboard.service.impl.JiraClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActionsServiceImpl
implements ActionsService {
    private static final Logger LOG = LoggerFactory.getLogger(ActionsServiceImpl.class);
    private static final Pattern namePattern = Pattern.compile("^Applicant name: (.*)$", 8);
    private static final Pattern emailPattern = Pattern.compile("^Applicant email: (.*)$", 8);
    @Autowired
    private JiraClient jiraClient;
    @Autowired
    private Manage manage;
    @Autowired
    private MailBox mailBox;
    @Autowired
    private Sab sabClient;

    public JiraResponse searchTasks(String idp, JiraFilter jiraFilter) {
        JiraResponse jiraResponse = this.jiraClient.searchTasks(idp, jiraFilter);
        List issues = jiraResponse.getIssues();
        Map serviceProviders = this.serviceProviders(issues, EntityType.saml20_sp);
        Map relyingParties = this.serviceProviders(issues, EntityType.oidc10_rp);
        Map singleTenants = this.serviceProviders(issues, EntityType.single_tenant_template);
        serviceProviders.putAll(relyingParties);
        serviceProviders.putAll(singleTenants);
        Map identityProviders = issues.stream().map(Action::getIdpId).filter(StringUtils::hasText).collect(Collectors.toSet()).stream().map(idpId -> this.manage.getIdentityProvider(idpId, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Provider::getId, Function.identity()));
        List enrichedActions = issues.stream().map(arg_0 -> this.addUser(arg_0)).map(action -> action.unbuild().spName(this.providerName((Provider)serviceProviders.get(action.getSpId()))).spEid(this.providerEid((Provider)serviceProviders.get(action.getSpId()))).idpName(this.providerName((Provider)identityProviders.get(action.getIdpId()))).build()).collect(Collectors.toList());
        jiraResponse.setIssues(enrichedActions);
        return jiraResponse;
    }

    private Map<String, ServiceProvider> serviceProviders(List<Action> issues, EntityType entityType) {
        Set entityIds = issues.stream().filter(action -> !StringUtils.hasText((String)action.getTypeMetaData()) || action.getTypeMetaData().equals(entityType.name())).map(Action::getSpId).filter(StringUtils::hasText).collect(Collectors.toSet());
        return entityIds.stream().map(spId -> this.manage.getServiceProvider(spId, entityType, true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Provider::getId, Function.identity()));
    }

    private String providerName(Provider provider) {
        return provider == null ? "Information unavailable" : provider.getName();
    }

    private Long providerEid(Provider provider) {
        return provider == null ? null : provider.getEid();
    }

    private Action addNames(Action action) {
        String typeMetaData = action.getTypeMetaData();
        EntityType entityType = StringUtils.hasText((String)typeMetaData) ? EntityType.valueOf((String)typeMetaData) : EntityType.saml20_sp;
        Optional serviceProvider = this.manage.getServiceProvider(action.getSpId(), entityType, true);
        Optional identityProvider = this.manage.getIdentityProvider(action.getIdpId(), true);
        return action.unbuild().idpName(identityProvider.map(Provider::getName).orElse("Information unavailable")).spName(serviceProvider.map(Provider::getName).orElse("Information unavailable")).build();
    }

    private Action addUser(Action action) {
        String body = action.getBody();
        Optional userEmail = this.findUserEmail(body);
        Optional userName = this.findUserName(body);
        return action.unbuild().userEmail(userEmail.orElse("unknown")).userName(userName.orElse("unknown")).build();
    }

    private Optional<String> findUserEmail(String body) {
        return this.matchingGroup(emailPattern, body);
    }

    private Optional<String> findUserName(String body) {
        return this.matchingGroup(namePattern, body);
    }

    private Optional<String> matchingGroup(Pattern pattern, String input) {
        if (!StringUtils.hasText((String)input)) {
            return Optional.empty();
        }
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Optional.ofNullable(matcher.group(1));
        }
        return Optional.empty();
    }

    public Action create(Action action) {
        String jiraKey = this.jiraClient.create(action);
        Action savedAction = this.addNames(action).unbuild().jiraKey(jiraKey).build();
        if (action.getType().equals((Object)Action.Type.LINKINVITE) || action.getType().equals((Object)Action.Type.UNLINKINVITE)) {
            Map transitions = this.jiraClient.validTransitions(jiraKey);
            String transitionId = (String)transitions.get("Dispatch");
            this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
            transitions = this.jiraClient.validTransitions(jiraKey);
            transitionId = (String)transitions.get("Accept");
            this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
            transitions = this.jiraClient.validTransitions(jiraKey);
            transitionId = (String)transitions.get("Waiting for customer");
            this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.of("Waiting for approval of SCV."));
        }
        return savedAction;
    }

    public Action connectWithoutInteraction(Action action, Optional<String> loaLevel) {
        Action savedAction = this.addNames(action);
        this.manage.connectWithoutInteraction(savedAction.getIdpId(), savedAction.getSpId(), savedAction.getTypeMetaData(), loaLevel);
        savedAction = savedAction.unbuild().rejected(false).build();
        if (!savedAction.isRejected()) {
            List idpEmails = this.sabClient.getSabEmailsForOrganization(action.getIdpId(), "SURFconextverantwoordelijke").stream().map(SabPerson::getEmail).collect(Collectors.toList());
            LOG.info("Sending emails 'automatic connection made' to IdP contact persons {}", idpEmails);
            if (!CollectionUtils.isEmpty(idpEmails)) {
                this.mailBox.sendDashboardConnectWithoutInteractionEmail(idpEmails, savedAction.getIdpName(), savedAction.getSpName(), savedAction.getSpId(), "idp", action.getBody(), action.getEmailContactPerson());
            }
            Optional serviceProvider = this.manage.getServiceProvider(action.getSpId(), EntityType.valueOf((String)action.getTypeMetaData()), true);
            List spEmails = this.spEmails(serviceProvider);
            LOG.info("{} emails 'automatic connection made' to SP contact persons {}", (Object)(action.isShouldSendEmail() ? "Sending " : "Not sending "), (Object)spEmails);
            if (!CollectionUtils.isEmpty((Collection)spEmails) && action.isShouldSendEmail()) {
                this.mailBox.sendDashboardConnectWithoutInteractionEmail(spEmails, savedAction.getIdpName(), savedAction.getSpName(), savedAction.getSpId(), "sp", action.getBody(), action.getEmailContactPerson());
            }
        }
        return savedAction;
    }

    protected List<String> spEmails(Optional<ServiceProvider> serviceProvider) {
        return serviceProvider.map(sp -> {
            List contactPersons = sp.getContactPersons();
            List<ContactPersonType> contactTypes = Arrays.asList(ContactPersonType.administrative, ContactPersonType.support, ContactPersonType.technical);
            for (ContactPersonType contactPersonType : contactTypes) {
                if (!contactPersons.stream().anyMatch(contactPerson -> contactPersonType.equals((Object)contactPerson.getContactPersonType()))) continue;
                return contactPersons.stream().filter(cp -> contactPersonType.equals((Object)cp.getContactPersonType())).map(ContactPerson::getEmailAddress).collect(Collectors.toList());
            }
            return null;
        }).filter(l -> l.stream().filter(Objects::nonNull).count() != 0L).orElse(new ArrayList());
    }

    public void rejectInviteRequest(String jiraKey, String comment) {
        this.approveInviteRequest(jiraKey, comment, false);
    }

    public void approveInviteRequest(String jiraKey, String comment, boolean transitionToResolved) {
        Map validTransitions = this.jiraClient.validTransitions(jiraKey);
        String transitionId = (String)validTransitions.get("Back in progress");
        this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
        validTransitions = this.jiraClient.validTransitions(jiraKey);
        transitionId = (String)validTransitions.get(transitionToResolved ? "Resolve" : "Support level");
        this.jiraClient.transition(jiraKey, transitionId, Optional.empty(), Optional.empty());
        this.jiraClient.comment(jiraKey, comment);
    }

    public void comment(String key, String comment) {
        this.jiraClient.comment(key, comment);
    }

    public void updateOptionalMessage(String jiraKey, String optionalMessage) {
        this.jiraClient.updateOptionalMessage(jiraKey, optionalMessage);
    }
}

