/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.Results;
import invite.config.HashGenerator;
import invite.exception.NotFoundException;
import invite.exception.UserRestrictionException;
import invite.model.APIToken;
import invite.model.Authority;
import invite.model.User;
import invite.repository.APITokenRepository;
import invite.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/tokens", "/api/external/v1/tokens"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class APITokenController {
    private static final Log LOG = LogFactory.getLog(APITokenController.class);
    private static final String TOKEN_KEY = "token_key";
    private final APITokenRepository apiTokenRepository;

    public APITokenController(APITokenRepository apiTokenRepository) {
        this.apiTokenRepository = apiTokenRepository;
    }

    @GetMapping(value={""})
    public ResponseEntity<List<APIToken>> apiTokensByInstitution(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /tokens for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        List apiTokens = user.isSuperUser() ? this.apiTokenRepository.findAll() : (user.isInstitutionAdmin() ? this.apiTokenRepository.findByOrganizationGUID(user.getOrganizationGUID()) : this.apiTokenRepository.findByOwner(user));
        return ResponseEntity.ok((Object)apiTokens);
    }

    @GetMapping(value={"generate-token"})
    public ResponseEntity<Map<String, String>> generateToken(@Parameter(hidden=true) User user, @Parameter(hidden=true) HttpServletRequest request) {
        LOG.debug((Object)String.format("GET /tokens/generateToken for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        String token = HashGenerator.generateToken();
        request.getSession().setAttribute(TOKEN_KEY, (Object)token);
        return ResponseEntity.ok(Map.of("token", token));
    }

    @PostMapping(value={""})
    public ResponseEntity<APIToken> create(@Validated @RequestBody APIToken apiTokenRequest, @Parameter(hidden=true) User user, @Parameter(hidden=true) HttpServletRequest request) {
        LOG.debug((Object)String.format("POST /tokens/create for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        String token = (String)request.getSession().getAttribute(TOKEN_KEY);
        if (!StringUtils.hasText((String)token)) {
            throw new UserRestrictionException();
        }
        APIToken apiToken = user.isSuperUser() || user.isInstitutionAdmin() ? new APIToken(user.getOrganizationGUID(), HashGenerator.hashToken((String)token), user.isSuperUser(), apiTokenRequest.getDescription()) : new APIToken(HashGenerator.hashToken((String)token), apiTokenRequest.getDescription(), user);
        apiToken = (APIToken)this.apiTokenRepository.save((Object)apiToken);
        return ResponseEntity.ok((Object)apiToken);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteToken(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("DELETE /tokens/deleteToken with id %s for user %s", id.toString(), user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.INVITER);
        APIToken apiToken = (APIToken)this.apiTokenRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("API token not found"));
        if (apiToken.isSuperUserToken() && !user.isSuperUser()) {
            throw new UserRestrictionException();
        }
        if (user.isInstitutionAdmin() && !apiToken.getOrganizationGUID().equals(user.getOrganizationGUID())) {
            throw new UserRestrictionException();
        }
        if (!(user.isSuperUser() || user.isInstitutionAdmin() || Objects.equals(user.getId(), apiToken.getOwner().getId()))) {
            throw new UserRestrictionException();
        }
        this.apiTokenRepository.delete((Object)apiToken);
        return Results.deleteResult();
    }
}

