/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.RoleValidator;
import invite.api.UserRoleResource;
import invite.exception.NotFoundException;
import invite.model.Role;
import invite.model.UserRole;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;

public class UserRoleOperations {
    private static final Log LOG = LogFactory.getLog(UserRoleOperations.class);
    private final UserRoleResource roleResource;

    public UserRoleOperations(UserRoleResource roleResource) {
        this.roleResource = roleResource;
    }

    public ResponseEntity<List<UserRole>> userRolesByRole(Long roleId, RoleValidator roleValidator) {
        LOG.debug((Object)"/userRolesByRole/");
        Role role = (Role)this.roleResource.getRoleRepository().findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        roleValidator.validate(role);
        List userRoles = this.roleResource.getUserRoleRepository().findByRole(role);
        userRoles.forEach(userRole -> userRole.setUserInfo(userRole.getUser().asMap()));
        return ResponseEntity.ok((Object)userRoles);
    }
}

