/*
 * Decompiled with CFR 0.152.
 */
package invite.model;

import invite.model.ApplicationUsage;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class RoleRequest
implements Serializable {
    @NotNull
    @NotBlank
    @Schema(description="Unique name of the role", example="Guest for my application", required=true)
    private String name;
    @Schema(description="Brief explanation of this role's purpose", example="Full access to all modules")
    private String description;
    @Schema(description="Number of days until the memberschip automaticly expires. Use either defaultExpiryDays or defaultExpiryDate", example="365")
    private Integer defaultExpiryDays;
    @Schema(description="Specific timestamp end date for this role membership. Use either defaultExpiryDays or defaultExpiryDate", example="2026-12-31T23:59:59Z")
    private Instant defaultExpiryDate;
    @Schema(description="If true, the user's email must match the invitation email", defaultValue="false")
    private boolean enforceEmailEquality;
    @Schema(description="The invite can only be accepted by an eduID account", defaultValue="false")
    private boolean eduIDOnly;
    @Schema(description="Allow changing the settings when sending an invite.", defaultValue="false")
    private boolean overrideSettingsAllowed;
    @Schema(description="The unique identifier of the associated organization, only to be used bu SUPER-admins and internal API's", example="550e8400-e29b-41d4-a716-446655440000")
    private String organizationGUID;
    @Schema(description="The email address used", example="550e8400-e29b-41d4-a716-446655440000")
    private String inviterDisplayName;
    private Set<ApplicationUsage> applicationUsages = new HashSet();

    @Generated
    public RoleRequest() {
    }

    @Generated
    public RoleRequest(String name, String description, Integer defaultExpiryDays, Instant defaultExpiryDate, boolean enforceEmailEquality, boolean eduIDOnly, boolean overrideSettingsAllowed, String organizationGUID, String inviterDisplayName, Set<ApplicationUsage> applicationUsages) {
        this.name = name;
        this.description = description;
        this.defaultExpiryDays = defaultExpiryDays;
        this.defaultExpiryDate = defaultExpiryDate;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.overrideSettingsAllowed = overrideSettingsAllowed;
        this.organizationGUID = organizationGUID;
        this.inviterDisplayName = inviterDisplayName;
        this.applicationUsages = applicationUsages;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getDefaultExpiryDays() {
        return this.defaultExpiryDays;
    }

    @Generated
    public Instant getDefaultExpiryDate() {
        return this.defaultExpiryDate;
    }

    @Generated
    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    @Generated
    public boolean isEduIDOnly() {
        return this.eduIDOnly;
    }

    @Generated
    public boolean isOverrideSettingsAllowed() {
        return this.overrideSettingsAllowed;
    }

    @Generated
    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    @Generated
    public String getInviterDisplayName() {
        return this.inviterDisplayName;
    }

    @Generated
    public Set<ApplicationUsage> getApplicationUsages() {
        return this.applicationUsages;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDefaultExpiryDays(Integer defaultExpiryDays) {
        this.defaultExpiryDays = defaultExpiryDays;
    }

    @Generated
    public void setDefaultExpiryDate(Instant defaultExpiryDate) {
        this.defaultExpiryDate = defaultExpiryDate;
    }

    @Generated
    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    @Generated
    public void setEduIDOnly(boolean eduIDOnly) {
        this.eduIDOnly = eduIDOnly;
    }

    @Generated
    public void setOverrideSettingsAllowed(boolean overrideSettingsAllowed) {
        this.overrideSettingsAllowed = overrideSettingsAllowed;
    }

    @Generated
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @Generated
    public void setInviterDisplayName(String inviterDisplayName) {
        this.inviterDisplayName = inviterDisplayName;
    }

    @Generated
    public void setApplicationUsages(Set<ApplicationUsage> applicationUsages) {
        this.applicationUsages = applicationUsages;
    }
}

