/*
 * Decompiled with CFR 0.152.
 */
package invite.api;

import invite.api.FullSearchQueryParser;
import invite.api.Results;
import invite.api.UserRoleOperations;
import invite.api.UserRoleResource;
import invite.audit.UserRoleAuditService;
import invite.config.Config;
import invite.exception.NotAllowedException;
import invite.exception.NotFoundException;
import invite.logging.AccessLogger;
import invite.logging.Event;
import invite.model.Authority;
import invite.model.Role;
import invite.model.UpdateUserRole;
import invite.model.User;
import invite.model.UserRole;
import invite.model.UserRoleAudit;
import invite.model.UserRoleProvisioning;
import invite.provision.ProvisioningService;
import invite.provision.scim.OperationType;
import invite.repository.RoleRepository;
import invite.repository.UserRepository;
import invite.repository.UserRoleRepository;
import invite.security.UserPermissions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/user_roles", "/api/external/v1/user_roles"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserRoleController
implements UserRoleResource {
    private static final Log LOG = LogFactory.getLog(UserRoleController.class);
    private final UserRoleRepository userRoleRepository;
    private final RoleRepository roleRepository;
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final Config config;
    private final UserRoleOperations userRoleOperations;
    private final UserRoleAuditService userRoleAuditService;

    public UserRoleController(UserRoleRepository userRoleRepository, RoleRepository roleRepository, UserRepository userRepository, ProvisioningService provisioningService, UserRoleAuditService userRoleAuditService, Config config) {
        this.userRoleRepository = userRoleRepository;
        this.roleRepository = roleRepository;
        this.userRepository = userRepository;
        this.provisioningService = provisioningService;
        this.config = config;
        this.userRoleAuditService = userRoleAuditService;
        this.userRoleOperations = new UserRoleOperations((UserRoleResource)this);
    }

    @GetMapping(value={"roles/{roleId}"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<UserRole>> byRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET user_roles/roles/%s for user %s", roleId, user.getEduPersonPrincipalName()));
        return this.userRoleOperations.userRolesByRole(roleId, role -> UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER));
    }

    @GetMapping(value={"managers/{roleId}"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<String>> managersByRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET user_roles/managers/%s for user %s", roleId, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        List userRoles = this.userRoleRepository.findByRoleAndAuthorityIn(role, List.of(Authority.MANAGER, Authority.INSTITUTION_ADMIN));
        return ResponseEntity.ok(userRoles.stream().map(userRole -> userRole.getUser().getEmail()).toList());
    }

    @GetMapping(value={"/consequences/{roleId}"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<Map<String, Object>>> consequencesDeleteRole(@PathVariable(value="roleId") Long roleId, @Parameter(hidden=true) User user) {
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        LOG.debug((Object)String.format("Fetching consequences delete role %s by user %s", role.getName(), user.getEduPersonPrincipalName()));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INSTITUTION_ADMIN);
        List userRoles = this.userRoleRepository.findByRole(role);
        List<Map> res = userRoles.stream().map(userRole -> Map.of("authority", userRole.getAuthority().name(), "userInfo", userRole.getUser().asMap())).toList();
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/search/{roleId}/{guests}"})
    @Transactional(readOnly=true)
    public ResponseEntity<Page<?>> searchPaginated(@PathVariable(value="roleId") Long roleId, @PathVariable(value="guests") boolean guests, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection, @Parameter(hidden=true) User user) {
        Page page;
        LOG.debug((Object)String.format("GET user_roles/search/%s for user %s", roleId, user.getEduPersonPrincipalName()));
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new NotFoundException("Role not found"));
        UserPermissions.assertRoleAccess((User)user, (Role)role, (Authority)Authority.INVITER);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        boolean queryHasText = StringUtils.hasText((String)query);
        query = queryHasText ? URLDecoder.decode((String)query, Charset.defaultCharset()) : query;
        String parsedQuery = queryHasText ? FullSearchQueryParser.parse((String)query) : "";
        boolean noSearchTokens = parsedQuery.equals("*");
        if (queryHasText && !noSearchTokens) {
            page = guests ? this.userRoleRepository.searchGuestsByPageWithKeyword(roleId, parsedQuery, (Pageable)pageable) : this.userRoleRepository.searchNonGuestsByPageWithKeyword(roleId, parsedQuery, (Pageable)pageable);
        } else if (noSearchTokens) {
            query = ((String)query).toUpperCase() + "%";
            page = guests ? this.userRoleRepository.searchGuestsByPageWithStrictSearch(roleId, (String)query, (Pageable)pageable) : this.userRoleRepository.searchNonGuestsByPageWithStrictSearch(roleId, (String)query, (Pageable)pageable);
        } else {
            page = guests ? this.userRoleRepository.searchGuestsByPage(roleId, (Pageable)pageable) : this.userRoleRepository.searchNonGuestsByPage(roleId, (Pageable)pageable);
        }
        return ResponseEntity.ok((Object)page);
    }

    @PostMapping(value={"user_role_provisioning"})
    @Operation(summary="Add Role to a User", description="Provision the User if the User is unknown and add the Role(s)")
    public ResponseEntity<User> userRoleProvisioning(@Validated @RequestBody UserRoleProvisioning userRoleProvisioning, @Parameter(hidden=true) User apiUser) {
        LOG.debug((Object)String.format("POST user_roles/user_role_provisioning for apiuser %s", apiUser.getEduPersonPrincipalName()));
        userRoleProvisioning.validate();
        UserPermissions.assertInstitutionAdmin((User)apiUser);
        List<Role> roles = userRoleProvisioning.roleIdentifiers.stream().map(roleId -> (Role)this.roleRepository.findById(roleId).orElseThrow(() -> new NotFoundException("Role not found"))).toList();
        UserPermissions.assertValidInvitation((User)apiUser, (Authority)userRoleProvisioning.intendedAuthority, roles);
        Optional userOptional = Optional.empty();
        if (StringUtils.hasText((String)userRoleProvisioning.sub)) {
            userOptional = this.userRepository.findBySubIgnoreCase(userRoleProvisioning.sub);
        } else if (StringUtils.hasText((String)userRoleProvisioning.eduPersonPrincipalName)) {
            userOptional = this.userRepository.findByEduPersonPrincipalNameIgnoreCase(userRoleProvisioning.eduPersonPrincipalName);
        } else if (StringUtils.hasText((String)userRoleProvisioning.email)) {
            userOptional = this.userRepository.findByEmailIgnoreCase(userRoleProvisioning.email);
        }
        User user = userOptional.orElseGet(() -> (User)this.userRepository.save((Object)new User(userRoleProvisioning)));
        List<UserRole> newUserRoles = roles.stream().map(role -> user.getUserRoles().stream().noneMatch(userRole -> userRole.getRole().getId().equals(role.getId())) ? user.addUserRole(new UserRole(apiUser.getName(), user, role, userRoleProvisioning.intendedAuthority, userRoleProvisioning.guestRoleIncluded, role.deriveExpirationDate())) : null).filter(Objects::nonNull).toList();
        newUserRoles.stream().filter(userRole -> userRole.getId() == null).forEach(userRole -> this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.ADD));
        this.userRepository.save((Object)user);
        AccessLogger.user((Log)LOG, (Event)Event.Created, (User)user);
        this.provisioningService.newUserRequest(user);
        newUserRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.add));
        return ResponseEntity.status((int)201).body((Object)user);
    }

    @PutMapping(value={""})
    public ResponseEntity<Map<String, Integer>> updateUserRoleExpirationDate(@Validated @RequestBody UpdateUserRole updateUserRole, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("PUT user_roles for user %s", user.getEduPersonPrincipalName()));
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)updateUserRole.getUserRoleId()).orElseThrow(() -> new NotFoundException("UserRole not found"));
        if (updateUserRole.getEndDate() != null && !this.config.isPastDateAllowed() && Instant.now().isAfter(updateUserRole.getEndDate())) {
            throw new NotAllowedException("End date must be after now");
        }
        UserPermissions.assertValidInvitation((User)user, (Authority)userRole.getAuthority(), List.of(userRole.getRole()));
        userRole.setEndDate(updateUserRole.getEndDate());
        this.userRoleRepository.save((Object)userRole);
        this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.UPDATE);
        this.provisioningService.updateUserRoleRequest(userRole);
        return Results.createResult();
    }

    @DeleteMapping(value={"/{id}/{isGuest}"})
    public ResponseEntity<Void> deleteUserRole(@PathVariable(value="id") Long id, @PathVariable(value="isGuest") Boolean isGuest, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("DELETE user_roles/%s for user %s", id, user.getEduPersonPrincipalName()));
        UserRole userRole = (UserRole)this.userRoleRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("UserRole not found"));
        User userOfUserRole = userRole.getUser();
        if (!userOfUserRole.getId().equals(user.getId())) {
            UserPermissions.assertValidInvitation((User)user, (Authority)(isGuest != false ? Authority.GUEST : userRole.getAuthority()), List.of(userRole.getRole()));
        }
        if (userRole.isGuestRoleIncluded()) {
            userRole.setGuestRoleIncluded(false);
            if (!isGuest.booleanValue()) {
                userRole.setAuthority(Authority.GUEST);
            }
            this.userRoleRepository.save((Object)userRole);
            this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.UPDATE);
            AccessLogger.userRole((Log)LOG, (Event)Event.Updated, (User)user, (UserRole)userRole);
        } else {
            this.userRoleAuditService.logAction(userRole, UserRoleAudit.ActionType.DELETE);
            this.provisioningService.deleteUserRoleRequest(userRole);
            this.userRoleRepository.deleteUserRoleById(id);
            AccessLogger.userRole((Log)LOG, (Event)Event.Deleted, (User)user, (UserRole)userRole);
        }
        return Results.deleteResult();
    }

    @Generated
    public UserRoleRepository getUserRoleRepository() {
        return this.userRoleRepository;
    }

    @Generated
    public RoleRepository getRoleRepository() {
        return this.roleRepository;
    }
}

