/*
 * Decompiled with CFR 0.152.
 */
package invite.provision;

import com.fasterxml.jackson.databind.ObjectMapper;
import crypto.KeyStore;
import invite.eduid.EduID;
import invite.eduid.EduIDProvision;
import invite.exception.InvalidInputException;
import invite.exception.RemoteException;
import invite.manage.Manage;
import invite.manage.ManageIdentifier;
import invite.model.Application;
import invite.model.Authority;
import invite.model.Provisionable;
import invite.model.RemoteProvisionedGroup;
import invite.model.RemoteProvisionedUser;
import invite.model.Role;
import invite.model.User;
import invite.model.UserRole;
import invite.provision.DefaultProvisioningResponse;
import invite.provision.Provisioning;
import invite.provision.ProvisioningResponse;
import invite.provision.ProvisioningService;
import invite.provision.ProvisioningServiceDefault;
import invite.provision.ProvisioningType;
import invite.provision.ScimUserIdentifier;
import invite.provision.eva.EvaClient;
import invite.provision.graph.GraphClient;
import invite.provision.graph.GraphResponse;
import invite.provision.scim.DisplayNameOperation;
import invite.provision.scim.GroupPatchRequest;
import invite.provision.scim.GroupRequest;
import invite.provision.scim.GroupURN;
import invite.provision.scim.Member;
import invite.provision.scim.MembersOperation;
import invite.provision.scim.Operation;
import invite.provision.scim.OperationType;
import invite.provision.scim.UserRequest;
import invite.repository.RemoteProvisionedGroupRepository;
import invite.repository.RemoteProvisionedUserRepository;
import invite.repository.RoleRepository;
import invite.repository.UserRoleRepository;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ProvisioningServiceDefault
implements ProvisioningService {
    private final RoleRepository roleRepository;
    private static final Log LOG = LogFactory.getLog(ProvisioningServiceDefault.class);
    private final ParameterizedTypeReference<Map<String, Object>> mapParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final ParameterizedTypeReference<String> stringParameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private final RestTemplate restTemplate = new RestTemplate();
    private final UserRoleRepository userRoleRepository;
    private final RemoteProvisionedUserRepository remoteProvisionedUserRepository;
    private final RemoteProvisionedGroupRepository remoteProvisionedGroupRepository;
    private final Manage manage;
    private final ObjectMapper objectMapper;
    private final String groupUrnPrefix;
    private final GraphClient graphClient;
    private final EvaClient evaClient;
    private final KeyStore keyStore;
    private final EduID eduID;

    @Autowired
    public ProvisioningServiceDefault(UserRoleRepository userRoleRepository, RemoteProvisionedUserRepository remoteProvisionedUserRepository, RemoteProvisionedGroupRepository remoteProvisionedGroupRepository, Manage manage, ObjectMapper objectMapper, KeyStore keyStore, EduID eduID, @Value(value="${voot.group_urn_domain}") String groupUrnPrefix, @Value(value="${config.eduid-idp-schac-home-organization}") String eduidIdpSchacHomeOrganization, @Value(value="${config.server-url}") String serverBaseURL, RoleRepository roleRepository) {
        this.userRoleRepository = userRoleRepository;
        this.remoteProvisionedUserRepository = remoteProvisionedUserRepository;
        this.remoteProvisionedGroupRepository = remoteProvisionedGroupRepository;
        this.manage = manage;
        this.objectMapper = objectMapper;
        this.keyStore = keyStore;
        this.groupUrnPrefix = groupUrnPrefix;
        this.eduID = eduID;
        this.graphClient = new GraphClient(serverBaseURL, eduidIdpSchacHomeOrganization, keyStore, objectMapper);
        this.evaClient = new EvaClient(keyStore, remoteProvisionedUserRepository);
        JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory();
        requestFactory.setReadTimeout(Duration.ofMinutes(1L));
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        this.roleRepository = roleRepository;
    }

    public Optional<GraphResponse> newUserRequest(User user) {
        LOG.info((Object)String.format("Provisioning newUserRequest for user: %s", user.getEmail()));
        List provisionings = this.getProvisionings(user);
        AtomicReference graphResponseReference = new AtomicReference();
        provisionings.stream().filter(provisioning -> this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user).isEmpty()).forEach(provisioning -> {
            UserRequest userRequest = new UserRequest(user, provisioning);
            this.resolveInstitutionalEduID(user, provisioning, userRequest);
            String userRequestJson = this.prettyJson((Object)userRequest);
            Optional provisioningResponse = this.newRequest(provisioning, userRequestJson, (Provisionable)user);
            provisioningResponse.ifPresent(response -> {
                if (!response.isErrorResponse() && StringUtils.hasText((String)response.remoteIdentifier())) {
                    RemoteProvisionedUser remoteProvisionedUser = new RemoteProvisionedUser(user, response.remoteIdentifier(), provisioning.getId());
                    this.remoteProvisionedUserRepository.save((Object)remoteProvisionedUser);
                }
                if (response.isGraphResponse()) {
                    graphResponseReference.set((GraphResponse)response);
                }
            });
        });
        return Optional.ofNullable((GraphResponse)graphResponseReference.get());
    }

    private void resolveInstitutionalEduID(User user, Provisioning provisioning, UserRequest request) {
        if (ScimUserIdentifier.eduID.equals((Object)provisioning.getScimUserIdentifier()) && request.getUserName().equals(user.getEduId())) {
            EduIDProvision eduIDProvision = new EduIDProvision(user.getEduId(), provisioning.getInstitutionGUID());
            String eduIdProvisionResponse = this.eduID.provisionEduid(eduIDProvision);
            request.setInsitutionalEduID(eduIdProvisionResponse);
        }
    }

    public void updateUserRequest(User user) {
        LOG.info((Object)String.format("Provisioning updateUserRequest for user: %s", user.getEmail()));
        List userProvisionings = this.getProvisionings(user);
        List provisionings = userProvisionings.stream().toList();
        provisionings.forEach(provisioning -> {
            if (this.hasEvaHook(provisioning)) {
                RequestEntity requestEntity = this.evaClient.updateUserRequest(provisioning, user);
                this.doExchange(requestEntity, APIType.USER_API, this.mapParameterizedTypeReference, provisioning);
            } else if (this.hasScimHook(provisioning)) {
                Optional provisionedUserOptional = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user);
                provisionedUserOptional.ifPresent(remoteProvisionedUser -> {
                    UserRequest userRequest = new UserRequest(user, provisioning, remoteProvisionedUser.getRemoteIdentifier());
                    this.resolveInstitutionalEduID(user, provisioning, userRequest);
                    String userRequestJson = this.prettyJson((Object)userRequest);
                    this.updateRequest(provisioning, userRequestJson, APIType.USER_API, remoteProvisionedUser.getRemoteIdentifier(), HttpMethod.PUT);
                });
            }
        });
    }

    public void updateUserRoleRequest(UserRole userRole) {
        LOG.info((Object)String.format("Provisioning updateUserRoleRequest for userRole: %s", userRole.getId()));
        List provisionings = this.getProvisionings(userRole.getUser());
        provisionings.forEach(provisioning -> {
            if (this.hasEvaHook(provisioning)) {
                try {
                    RequestEntity requestEntity = this.evaClient.updateUserRequest(provisioning, userRole.getUser());
                    this.doExchange(requestEntity, APIType.USER_API, this.stringParameterizedTypeReference, provisioning);
                }
                catch (InvalidInputException e) {
                    LOG.error((Object)"Error from evaClient", (Throwable)e);
                }
            }
        });
    }

    public void deleteUserRequest(User user) {
        LOG.info((Object)String.format("provisioning deleteUserRequest for user %s", user.getEmail()));
        user.getUserRoles().forEach(userRole -> this.updateGroupRequest(userRole, OperationType.remove));
        List provisionings = this.getProvisionings(user);
        this.deprovisionUser(user, provisionings);
    }

    public void deleteUserRoleRequest(UserRole userRole) {
        LOG.info((Object)String.format("Provisioning deleteUserRoleRequest for role %s", userRole.getId()));
        this.getProvisionings(userRole.getUser()).stream().filter(arg_0 -> this.hasEvaHook(arg_0)).forEach(provisioning -> {
            RequestEntity requestEntity = this.evaClient.deleteUserRequest(provisioning, userRole.getUser());
            if (requestEntity != null) {
                this.doExchange(requestEntity, APIType.USER_API, this.stringParameterizedTypeReference, provisioning);
            }
        });
        this.updateGroupRequest(userRole, OperationType.remove);
        User user = userRole.getUser();
        List userRoleProvisionings = this.getProvisioningsUserRole(user, userRole);
        List<String> otherProvisioningIdentifiers = user.getUserRoles().stream().filter(otherUserRole -> !otherUserRole.getId().equals(userRole.getId())).map(otherUserRole -> this.getProvisioningsUserRole(user, otherUserRole)).flatMap(Collection::stream).map(Provisioning::getId).toList();
        List<Provisioning> provisionings = userRoleProvisionings.stream().filter(provisioning -> !otherProvisioningIdentifiers.contains(provisioning.getId())).toList();
        this.deprovisionUser(user, provisionings);
    }

    public void deleteUserRequest(Role role) {
        LOG.info((Object)String.format("Provisioning deleteUserRequest for role: %s", role.getId()));
        List manageIdentifiers = this.getManageIdentifiers(role);
        List<Provisioning> allRoleProvisionings = this.manage.provisioning((Collection)manageIdentifiers).stream().map(Provisioning::new).toList();
        List userRoles = this.userRoleRepository.findByRole(role);
        userRoles.forEach(userRole -> {
            User user = userRole.getUser();
            List otherManageIdentifiers = user.getUserRoles().stream().filter(otherUserRole -> !otherUserRole.getId().equals(userRole.getId())).map(otherUserRole -> user.manageIdentifierSet(userRole)).flatMap(Collection::stream).toList();
            List<Provisioning> provisionings = allRoleProvisionings.stream().filter(provisioning -> provisioning.getRemoteApplications().stream().noneMatch(otherManageIdentifiers::contains)).toList();
            this.deprovisionUser(user, provisionings);
        });
    }

    private void deprovisionUser(User user, List<Provisioning> provisionings) {
        provisionings.forEach(provisioning -> {
            Optional provisionedUserOptional = this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), user);
            if (provisionedUserOptional.isPresent()) {
                LOG.info((Object)String.format("Provisioning deprovisionUser for user: %s", user.getEmail()));
                RemoteProvisionedUser remoteProvisionedUser = (RemoteProvisionedUser)provisionedUserOptional.get();
                String remoteIdentifier = remoteProvisionedUser.getRemoteIdentifier();
                UserRequest userRequest = new UserRequest(user, provisioning, remoteIdentifier);
                this.resolveInstitutionalEduID(user, provisioning, userRequest);
                String userRequestJson = this.prettyJson((Object)userRequest);
                this.deleteRequest(provisioning, userRequestJson, (Provisionable)user, remoteIdentifier);
                this.remoteProvisionedUserRepository.delete((Object)remoteProvisionedUser);
            } else {
                LOG.info((Object)String.format("No provisionings found in deprovisionUser for user: %s", user.getEmail()));
            }
        });
    }

    public void newGroupRequest(Role role) {
        List provisionings = this.getProvisionings(role);
        provisionings.forEach(provisioning -> {
            Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role);
            if (provisionedGroupOptional.isEmpty()) {
                LOG.info((Object)String.format("Provisioning newGroupRequest for role: %s", role.getId()));
                String groupRequest = this.constructGroupRequest(role, null, Collections.emptyList());
                Optional provisioningResponse = this.newRequest(provisioning, groupRequest, (Provisionable)role);
                provisioningResponse.ifPresent(response -> {
                    RemoteProvisionedGroup remoteProvisionedGroup = new RemoteProvisionedGroup(role, response.remoteIdentifier(), provisioning.getId());
                    this.remoteProvisionedGroupRepository.save((Object)remoteProvisionedGroup);
                });
            } else {
                LOG.info((Object)String.format("No provisionings found in newGroupRequest for role: %s", role.getId()));
            }
        });
    }

    public void updateGroupRequest(UserRole userRole, OperationType operationType) {
        LOG.info((Object)String.format("Provisioning updateGroupRequest for userRole: %s", userRole.getId()));
        if (!userRole.getAuthority().equals((Object)Authority.GUEST) && !userRole.isGuestRoleIncluded()) {
            return;
        }
        Role role = userRole.getRole();
        List provisionings = this.getProvisionings(role).stream().toList();
        provisionings.forEach(provisioning -> {
            if (this.hasScimHook(provisioning) && !provisioning.isScimUserProvisioningOnly()) {
                Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role);
                provisionedGroupOptional.ifPresentOrElse(provisionedGroup -> {
                    List<UserRole> userRoles = new ArrayList<UserRole>();
                    if (provisioning.isScimUpdateRolePutMethod()) {
                        userRoles = this.userRoleRepository.findByRole(userRole.getRole()).stream().filter(userRoleDB -> userRoleDB.getAuthority().equals((Object)Authority.GUEST) || userRoleDB.isGuestRoleIncluded()).collect(Collectors.toCollection(ArrayList::new));
                        boolean userRolePresent = userRoles.stream().anyMatch(dbUserRole -> dbUserRole.getId().equals(userRole.getId()));
                        if (operationType.equals((Object)OperationType.add) && !userRolePresent) {
                            userRoles.add(userRole);
                        } else if (operationType.equals((Object)OperationType.remove) && userRolePresent) {
                            userRoles = userRoles.stream().filter(dbUserRole -> !dbUserRole.getId().equals(userRole.getId())).collect(Collectors.toCollection(ArrayList::new));
                        }
                    } else {
                        userRoles.add(userRole);
                    }
                    this.sendGroupPutRequest(provisioning, provisionedGroup, userRoles, role, operationType);
                }, () -> {
                    this.newGroupRequest(role);
                    this.updateGroupRequest(userRole, operationType);
                });
            }
        });
    }

    private void sendGroupPutRequest(Provisioning provisioning, RemoteProvisionedGroup provisionedGroup, List<UserRole> userRoles, Role role, OperationType operationType) {
        LOG.info((Object)String.format("Provisioning sendGroupPutRequest for provisioning: %s", provisioning.getId()));
        List<String> userScimIdentifiers = userRoles.stream().map(userRole -> this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), userRole.getUser()).or(() -> {
            this.newUserRequest(userRole.getUser());
            return this.remoteProvisionedUserRepository.findByManageProvisioningIdAndUser(provisioning.getId(), userRole.getUser());
        })).filter(Optional::isPresent).map(Optional::get).map(RemoteProvisionedUser::getRemoteIdentifier).toList();
        if (!userScimIdentifiers.isEmpty() || operationType.equals((Object)OperationType.replace)) {
            if (provisioning.isScimUpdateRolePutMethod()) {
                String groupRequest = this.constructGroupRequest(role, provisionedGroup.getRemoteIdentifier(), userScimIdentifiers);
                this.updateRequest(provisioning, groupRequest, APIType.GROUP_API, provisionedGroup.getRemoteIdentifier(), HttpMethod.PUT);
            } else {
                GroupPatchRequest request = operationType.equals((Object)OperationType.replace) ? new GroupPatchRequest((Operation)new DisplayNameOperation(role.getName())) : new GroupPatchRequest((Operation)new MembersOperation(operationType, userScimIdentifiers));
                String groupRequest = this.prettyJson((Object)request);
                this.updateRequest(provisioning, groupRequest, APIType.GROUP_API, provisionedGroup.getRemoteIdentifier(), HttpMethod.PATCH);
            }
        }
    }

    public void updateGroupRequest(List<String> previousManageIdentifiers, Role newRole, boolean nameChanged) {
        List previousManageIdentifiersSorted = previousManageIdentifiers.stream().sorted().toList();
        List newManageIdentifiers = this.getManageIdentifiers(newRole);
        boolean noApplicationsChanged = previousManageIdentifiers.equals(newManageIdentifiers);
        if (!nameChanged && noApplicationsChanged) {
            LOG.info((Object)String.format("Group %s update request with no difference in manage identifiers (%s). No action required", newRole.getName(), newManageIdentifiers));
            return;
        }
        LOG.info((Object)String.format("Group %s update request with different manage identifiers. Old identifiers %s, new identifiers %s", newRole.getName(), previousManageIdentifiers, newManageIdentifiers));
        List<String> addedManageIdentifiers = newManageIdentifiers.stream().filter(id -> !previousManageIdentifiersSorted.contains(id) || nameChanged).toList();
        List<String> deletedManageIdentifiers = previousManageIdentifiers.stream().filter(id -> !newManageIdentifiers.contains(id)).toList();
        this.manage.provisioning(addedManageIdentifiers).stream().map(Provisioning::new).filter(provisioning -> !provisioning.isScimUserProvisioningOnly()).forEach(provisioning -> {
            Optional provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), newRole);
            if (provisionedGroupOptional.isEmpty()) {
                this.newGroupRequest(newRole);
                provisionedGroupOptional = this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), newRole);
            }
            provisionedGroupOptional.ifPresent(provisionedGroup -> {
                List userRoles = this.userRoleRepository.findByRole(newRole);
                this.sendGroupPutRequest(provisioning, provisionedGroup, userRoles, newRole, OperationType.replace);
            });
        });
        LOG.info((Object)String.format("Deleting existing provisionings %s from group %s", deletedManageIdentifiers, newRole.getName()));
        List<Provisioning> provisionings = this.manage.provisioning(deletedManageIdentifiers).stream().map(Provisioning::new).toList();
        this.deleteGroupRequest(newRole, provisionings);
    }

    public void deleteGroupRequest(Role role) {
        List provisionings = this.getProvisionings(role);
        this.deleteGroupRequest(role, provisionings);
    }

    public List<Provisioning> getProvisionings(List<UserRole> userRoles) {
        Set manageIdentifiers = userRoles.stream().map(userRole -> this.getManageIdentifiers(userRole.getRole())).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.manage.provisioning(manageIdentifiers).stream().map(Provisioning::new).toList();
    }

    private void deleteGroupRequest(Role role, List<Provisioning> provisionings) {
        LOG.info((Object)String.format("Provisioning deleteGroupRequest for role %s", role.getId()));
        provisionings.stream().filter(provisioning -> !provisioning.isScimUserProvisioningOnly()).forEach(provisioning -> this.remoteProvisionedGroupRepository.findByManageProvisioningIdAndRole(provisioning.getId(), role).ifPresent(remoteProvisionedGroup -> {
            String remoteIdentifier = remoteProvisionedGroup.getRemoteIdentifier();
            String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
            String groupRequest = this.prettyJson((Object)new GroupRequest(externalId, remoteIdentifier, role.getName(), Collections.emptyList()));
            this.deleteRequest(provisioning, groupRequest, (Provisionable)role, remoteIdentifier);
            this.remoteProvisionedGroupRepository.delete(remoteProvisionedGroup);
        }));
    }

    private String constructGroupRequest(Role role, String remoteGroupScimIdentifier, List<String> remoteUserScimIdentifiers) {
        HashSet<String> uniqueRemoteUserScimIdentifiers = new HashSet<String>(remoteUserScimIdentifiers);
        List<Member> members = uniqueRemoteUserScimIdentifiers.stream().filter(StringUtils::hasText).map(Member::new).toList();
        String externalId = GroupURN.urnFromRole((String)this.groupUrnPrefix, (Role)role);
        return this.prettyJson((Object)new GroupRequest(externalId, remoteGroupScimIdentifier, role.getName(), members));
    }

    private Optional<ProvisioningResponse> newRequest(Provisioning provisioning, String request, Provisionable provisionable) {
        boolean isUser = provisionable instanceof User;
        APIType apiType = isUser ? APIType.USER_API : APIType.GROUP_API;
        RequestEntity requestEntity = null;
        boolean requiresRemoteIdentifier = false;
        if (this.hasEvaHook(provisioning) && isUser) {
            LOG.info((Object)String.format("Provisioning new eva account for user %s and provisioning %s", ((User)provisionable).getEmail(), provisioning.getEntityId()));
            requestEntity = this.evaClient.newUserRequest(provisioning, (User)provisionable);
        } else if (this.hasScimHook(provisioning) && (isUser || !provisioning.isScimUserProvisioningOnly())) {
            LOG.info((Object)String.format("Provisioning new SCIM account for provisionable %s and provisioning %s", provisionable.getName(), provisioning.getEntityId()));
            URI uri = this.provisioningUri(provisioning, apiType, Optional.empty());
            requiresRemoteIdentifier = true;
            requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(provisioning), HttpMethod.POST, uri);
        } else if (this.hasGraphHook(provisioning) && isUser) {
            LOG.info((Object)String.format("Provisioning new Graph user for provisionable %s and provisioning %s", ((User)provisionable).getEmail(), provisioning.getEntityId()));
            GraphResponse graphResponse = this.graphClient.newUserRequest(provisioning, (User)provisionable);
            return Optional.of(graphResponse);
        }
        if (requestEntity != null) {
            Map results = (Map)this.doExchange(requestEntity, apiType, this.mapParameterizedTypeReference, provisioning);
            String id = (String)results.get("id");
            if (!StringUtils.hasText((String)id) && requiresRemoteIdentifier) {
                String errorMessage = String.format("Error in %s response %s send to entityID %s. ID is required, but not present in SCIM response.", apiType, results, provisioning.getEntityId());
                throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, null);
            }
            return Optional.of(new DefaultProvisioningResponse(id));
        }
        return Optional.empty();
    }

    private void updateRequest(Provisioning provisioning, String request, APIType apiType, String remoteIdentifier, HttpMethod httpMethod) {
        if (this.hasScimHook(provisioning) && (APIType.USER_API.equals((Object)apiType) || !provisioning.isScimUserProvisioningOnly())) {
            URI uri = this.provisioningUri(provisioning, apiType, Optional.ofNullable(remoteIdentifier));
            RequestEntity requestEntity = new RequestEntity((Object)request, (MultiValueMap)this.httpHeaders(provisioning), httpMethod, uri);
            this.doExchange(requestEntity, apiType, this.mapParameterizedTypeReference, provisioning);
        }
    }

    private List<Provisioning> getProvisionings(User user) {
        Set manageIdentifiers = user.manageIdentifierSet();
        List<String> identifiers = manageIdentifiers.stream().map(ManageIdentifier::manageId).toList();
        return this.manage.provisioning(identifiers).stream().map(Provisioning::new).toList();
    }

    private List<Provisioning> getProvisioningsUserRole(User user, UserRole userRole) {
        Set manageIdentifiers = user.manageIdentifierSet(userRole);
        List<String> identifiers = manageIdentifiers.stream().map(ManageIdentifier::manageId).toList();
        return this.manage.provisioning(identifiers).stream().map(Provisioning::new).toList();
    }

    private List<Provisioning> getProvisionings(Role role) {
        List manageIdentifiers = this.getManageIdentifiers(role);
        return this.manage.provisioning((Collection)manageIdentifiers).stream().map(Provisioning::new).toList();
    }

    private List<String> getManageIdentifiers(Role role) {
        return role.applicationsUsed().stream().map(Application::getManageId).distinct().sorted().toList();
    }

    private void deleteRequest(Provisioning provisioning, String request, Provisionable provisionable, String remoteIdentifier) {
        boolean isUser = provisionable instanceof User;
        APIType apiType = isUser ? APIType.USER_API : APIType.GROUP_API;
        RequestEntity requestEntity = null;
        if (this.hasEvaHook(provisioning) && isUser) {
            requestEntity = this.evaClient.deleteUserRequest(provisioning, (User)provisionable);
        } else if (this.hasScimHook(provisioning) && (isUser || !provisioning.isScimUserProvisioningOnly())) {
            URI uri = this.provisioningUri(provisioning, apiType, Optional.ofNullable(remoteIdentifier));
            HttpHeaders headers = this.httpHeaders(provisioning);
            requestEntity = new RequestEntity((Object)request, (MultiValueMap)headers, HttpMethod.DELETE, uri);
        } else if (this.hasGraphHook(provisioning) && isUser) {
            this.graphClient.deleteUser((User)provisionable, provisioning, remoteIdentifier);
        }
        if (requestEntity != null) {
            this.doExchange(requestEntity, apiType, this.stringParameterizedTypeReference, provisioning);
        }
    }

    private <T, S> T doExchange(RequestEntity<S> requestEntity, APIType api, ParameterizedTypeReference<T> typeReference, Provisioning provisioning) {
        try {
            LOG.info((Object)String.format("Send %s Provisioning request (protocol %s) with %s httpMethod %s and body %s to provisioning-entityId %s", api.getDisplay(), provisioning.getProvisioningType(), requestEntity.getMethod(), requestEntity.getUrl(), requestEntity.getBody(), provisioning.getEntityId()));
            ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, typeReference);
            Object body = responseEntity.getBody();
            HttpStatusCode statusCode = responseEntity.getStatusCode();
            LOG.info((Object)String.format("Received response with status %s and body %s for Provisioning request to provisioning-entityId %s", statusCode, body, provisioning.getEntityId()));
            return (T)body;
        }
        catch (RestClientException e) {
            String errorMessage = String.format("Error %s SCIM request (entityID %s) to %s with %s httpMethod and body %s", api, provisioning.getEntityId(), requestEntity.getUrl(), requestEntity.getMethod(), requestEntity.getBody());
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new RemoteException(HttpStatus.BAD_REQUEST, errorMessage, (Throwable)e);
        }
    }

    private boolean hasEvaHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.eva);
    }

    private boolean hasScimHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.scim);
    }

    private boolean hasGraphHook(Provisioning provisioning) {
        return provisioning.getProvisioningType().equals((Object)ProvisioningType.graph);
    }

    private URI provisioningUri(Provisioning provisioning, APIType apiType, Optional<String> remoteIdentifier) {
        String postFix = remoteIdentifier.map(identifier -> "/" + identifier).orElse("");
        return URI.create(String.format("%s/%s%s", provisioning.getScimUrl(), apiType.getDisplay(), postFix));
    }

    private String prettyJson(Object obj) {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    private String decryptScimPassword(Provisioning provisioning) {
        String scimPassword = provisioning.getScimPassword();
        return this.keyStore.isEncryptedSecret(scimPassword) ? this.keyStore.decodeAndDecrypt(scimPassword) : scimPassword;
    }

    private String decryptScimBearerToken(Provisioning provisioning) {
        String scimBearerToken = provisioning.getScimBearerToken();
        return this.keyStore.isEncryptedSecret(scimBearerToken) ? this.keyStore.decodeAndDecrypt(scimBearerToken) : scimBearerToken;
    }

    private HttpHeaders httpHeaders(Provisioning provisioning) {
        HttpHeaders headers = new HttpHeaders();
        switch (3.$SwitchMap$invite$provision$ProvisioningType[provisioning.getProvisioningType().ordinal()]) {
            case 1: {
                if (StringUtils.hasText((String)provisioning.getScimPassword())) {
                    headers.setBasicAuth(provisioning.getScimUser(), this.decryptScimPassword(provisioning));
                } else if (StringUtils.hasText((String)provisioning.getScimBearerToken())) {
                    String decryptedScimBearerToken = this.decryptScimBearerToken(provisioning);
                    LOG.debug((Object)String.format("Inserting header Authorization: Bearer %s ", decryptedScimBearerToken));
                    headers.add("Authorization", String.format("Bearer %s", decryptedScimBearerToken));
                }
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
                break;
            }
            case 2: {
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                headers.add("X-Api-Key", provisioning.getEvaToken());
            }
        }
        return headers;
    }
}

