/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PolicyValidationHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public PolicyValidationHook(MetaDataAutoConfiguration metaDataAutoConfiguration) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PDP.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        this.validate(newMetaData);
        return super.prePut(previous, newMetaData, user);
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        this.validate(metaData);
        return super.prePost(metaData, user);
    }

    private void validate(MetaData newMetaData) {
        Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PDP.getType());
        Map data = newMetaData.getData();
        ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
        boolean isRegularPolicy = "reg".equals(data.get("type"));
        if (isRegularPolicy) {
            List attributes;
            if (!StringUtils.hasText((String)((String)data.get("denyAdviceNl")))) {
                failures.add(new ValidationException(schema, "Deny advice Nl is required for regular policies", "denyAdviceNl"));
            }
            if (!StringUtils.hasText((String)((String)data.get("denyAdvice")))) {
                failures.add(new ValidationException(schema, "Deny advice is required for regular policies", "denyAdvice"));
            }
            if (CollectionUtils.isEmpty((Collection)(attributes = (List)data.get("attributes"))) || attributes.stream().anyMatch(arg_0 -> this.invalidAttribute(arg_0))) {
                failures.add(new ValidationException(schema, "One or more attributes with non-empty value(s) are required for regular policies", "attributes"));
            }
        } else {
            List loas = (List)data.get("loas");
            if (CollectionUtils.isEmpty((Collection)loas) || loas.stream().anyMatch(loa -> ((List)loa.get("attributes")).stream().anyMatch(arg_0 -> this.invalidAttribute(arg_0)))) {
                failures.add(new ValidationException(schema, "One or more level of assurances are required for regular policies (without invalid attributes)", "loas"));
            }
        }
        ValidationException.throwFor((Schema)schema, failures);
    }

    private boolean invalidAttribute(Map<String, Object> attribute) {
        return !StringUtils.hasText((String)((String)attribute.get("value")));
    }
}

