/*
 * Decompiled with CFR 0.152.
 */
package myconext.log;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import myconext.model.User;
import org.apache.commons.logging.Log;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MDCContext {
    private MDCContext() {
    }

    public static void logWithContext(User user, String action, String target, Log log, String message) {
        MDC.setContextMap(Map.of("action", action, "target", target, "result", "ok", "tag", "myconext_loginstats", "userid", user.getEmail()));
        log.info((Object)String.format("%S %s %s", message, user.getEmail(), user.getId()));
    }

    public static void logLoginWithContext(User user, String loginMethod, boolean success, Log log, String message, HttpServletRequest request, String authnContextClassRefValue, List<String> authenticationContextClassReferences) {
        MDC.setContextMap(Map.of("login_method", loginMethod, "action", "login", "result", success ? "ok" : "error", "tag", "myconext_loginstats", "userid", user.getEmail()));
        String ipAddress = MDCContext.resolve((HttpServletRequest)request);
        String userAgent = request.getHeader("User-Agent");
        log.info((Object)String.format("%s %s %s, ipAddress: %s, type: %s, userAgent: %s, requestedACR: %s, responseACR: %s", message, user.getEmail(), user.getId(), ipAddress, loginMethod, userAgent, CollectionUtils.isEmpty(authenticationContextClassReferences) ? "[]" : String.join((CharSequence)", ", authenticationContextClassReferences), authnContextClassRefValue));
    }

    public static String resolve(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        String xRealIp = request.getHeader("X-Real-IP");
        String remoteAddr = request.getRemoteAddr();
        return Stream.of(xRealIp, xForwardedFor, remoteAddr).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

