/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import lombok.Generated;
import myconext.exceptions.ForbiddenException;
import myconext.security.VerificationCodeGenerator;

public class OneTimeLoginCode
implements Serializable {
    private static final int VALIDITY_LOGIN_CODE_MINUTES = 10;
    private String code;
    private long createdAt;
    private long delay;

    public OneTimeLoginCode(String code) {
        this.code = code;
        this.createdAt = System.currentTimeMillis();
        this.delay = 1000L;
    }

    public boolean attemptOneTimeLoginVerification(String code) {
        long now = System.currentTimeMillis();
        if (now < this.createdAt + this.delay) {
            throw new ForbiddenException("Attempt forbidden due to rate limit");
        }
        boolean equals = MessageDigest.isEqual(this.code.getBytes(StandardCharsets.UTF_8), code.getBytes(StandardCharsets.UTF_8));
        if (equals) {
            return true;
        }
        this.delay *= 2L;
        return false;
    }

    public boolean isExpired() {
        return this.createdAt + 600000L < System.currentTimeMillis();
    }

    public boolean isCodeAlmostExpired() {
        if (this.createdAt + 540000L < System.currentTimeMillis()) {
            String newCode;
            this.code = newCode = VerificationCodeGenerator.generateOneTimeLoginCode();
            return true;
        }
        return false;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public OneTimeLoginCode() {
    }

    @Generated
    public String toString() {
        return "OneTimeLoginCode(code=" + this.getCode() + ", createdAt=" + this.getCreatedAt() + ", delay=" + this.getDelay() + ")";
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }
}

