/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import com.mongodb.client.MongoClient;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import myconext.cron.AbstractNodeLeader;
import myconext.repository.AuthenticationRepository;
import myconext.repository.EnrollmentRepository;
import myconext.repository.RegistrationRepository;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import tiqr.org.model.Authentication;
import tiqr.org.model.Enrollment;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;

@Component
public class TiqrCleaner
extends AbstractNodeLeader {
    public static final String LOCK_NAME = "tiqr_cleaner_usage_lock_name";
    private static final Log LOG = LogFactory.getLog(TiqrCleaner.class);
    private final RegistrationRepository registrationRepository;
    private final AuthenticationRepository authenticationRepository;
    private final EnrollmentRepository enrollmentRepository;
    private final UserRepository userRepository;

    @Autowired
    public TiqrCleaner(RegistrationRepository registrationRepository, AuthenticationRepository authenticationRepository, EnrollmentRepository enrollmentRepository, UserRepository userRepository, MongoClient mongoClient, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${mongodb_db}") String databaseName) {
        super(LOCK_NAME, mongoClient, databaseName, cronJobResponsible);
        this.registrationRepository = registrationRepository;
        this.authenticationRepository = authenticationRepository;
        this.enrollmentRepository = enrollmentRepository;
        this.userRepository = userRepository;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        super.perform("TiqrCleaner#clean", () -> this.doClean());
    }

    private void doClean() {
        Instant hourAgo = Instant.now().minus(1L, ChronoUnit.HOURS);
        this.info(Authentication.class, this.authenticationRepository.deleteByUpdatedBefore(hourAgo).longValue());
        List registrations = this.registrationRepository.findByUpdatedBeforeAndStatus(hourAgo, RegistrationStatus.INITIALIZED);
        long deletedCount = 0L;
        for (Registration registration : registrations) {
            this.userRepository.findById((Object)registration.getUserId()).ifPresent(user -> {
                user.getSurfSecureId().clear();
                this.userRepository.save(user);
                LOG.info((Object)String.format("Clean surfSecureId settings for user %s, because of stale and initialized registration", user.getEmail()));
            });
            this.registrationRepository.delete(registration);
            ++deletedCount;
        }
        this.info(Registration.class, deletedCount);
        this.info(Enrollment.class, this.enrollmentRepository.deleteByUpdatedBefore(hourAgo).longValue());
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted Tiqr %s instances of %s in cleanup", count, clazz));
    }
}

