/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URISyntaxException;
import java.util.Map;
import myconext.exceptions.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
@Hidden
public class DefaultErrorController
implements ErrorController {
    private static final Log LOG = LogFactory.getLog(DefaultErrorController.class);
    private final ErrorAttributes errorAttributes;

    @Autowired
    public DefaultErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity error(HttpServletRequest request) throws URISyntaxException {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.of((ErrorAttributeOptions.Include[])new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION, ErrorAttributeOptions.Include.STATUS, ErrorAttributeOptions.Include.MESSAGE, ErrorAttributeOptions.Include.ERROR, ErrorAttributeOptions.Include.BINDING_ERRORS}));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error == null) {
            statusCode = "unauthorized".equalsIgnoreCase(result.getOrDefault("message", "")) ? HttpStatus.UNAUTHORIZED : (result.containsKey("status") && (Integer)result.get("status") != 999 ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR);
        } else {
            LOG.error((Object)String.format("Error occurred; %s %s", error.getClass(), error), error);
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : (result.containsKey("status") && !result.get("status").equals(500) ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.BAD_REQUEST);
            if (error instanceof RemoteException) {
                result.put("reference", ((RemoteException)error).getReference());
            }
        }
        result.put("status", statusCode.value());
        return ResponseEntity.status((HttpStatusCode)statusCode).body((Object)result);
    }
}

