/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import java.util.Arrays;
import oidc.model.OpenIDClient;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecureEndpoint {
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    boolean secretsMatch(PlainClientSecret clientSecret, OpenIDClient openIDClient) {
        String secret = clientSecret.getClientSecret().getValue();
        if (secret.getBytes().length > 72) {
            byte[] first72bytes = Arrays.copyOf(secret.getBytes(), 72);
            secret = new String(first72bytes);
        }
        return this.passwordEncoder.matches((CharSequence)secret, openIDClient.getSecret());
    }
}

