/*
 * Decompiled with CFR 0.152.
 */
package oidc.saml;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oidc.endpoints.AuthorizationEndpoint;
import oidc.exceptions.CookiesNotSupportedException;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.JWTRequestURIMismatchException;
import oidc.exceptions.UnknownClientException;
import oidc.exceptions.WrappingException;
import oidc.log.MDCContext;
import oidc.manage.ServiceProviderTranslation;
import oidc.model.AuthenticationRequest;
import oidc.model.OpenIDClient;
import oidc.repository.AuthenticationRequestRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.secure.JWTRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.IDPEntryBuilder;
import org.opensaml.saml.saml2.core.impl.IDPListBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.core.impl.RequesterIDBuilder;
import org.opensaml.saml.saml2.core.impl.ScopingBuilder;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml5AuthenticationRequestResolver;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AuthnRequestContextConsumer
implements Consumer<OpenSaml5AuthenticationRequestResolver.AuthnRequestContext> {
    public static final String REDIRECT_URI_VALID = "REDIRECT_URI_VALID";
    private static final Log LOG = LogFactory.getLog(AuthnRequestContextConsumer.class);
    private final OpenIDClientRepository openIDClientRepository;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
    private final RequestCache requestCache;

    public AuthnRequestContextConsumer(OpenIDClientRepository openIDClientRepository, AuthenticationRequestRepository authenticationRequestRepository, RequestCache requestCache) {
        this.openIDClientRepository = openIDClientRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.requestCache = requestCache;
    }

    @Override
    public void accept(OpenSaml5AuthenticationRequestResolver.AuthnRequestContext authnRequestContext) {
        String clientId;
        AuthnRequest authnRequest = authnRequestContext.getAuthnRequest();
        HttpServletRequest request = authnRequestContext.getRequest();
        HttpSession session = request.getSession(false);
        if (session == null) {
            LOG.warn((Object)"There is no session in the HttpServletRequest. CookiesNotSupportedException will be thrown");
        } else {
            Enumeration attributeNames = session.getAttributeNames();
            ArrayList list = Collections.list(attributeNames);
            if (!list.contains("SPRING_SECURITY_SAVED_REQUEST")) {
                LOG.warn((Object)("There is a session in the HttpServletRequest with ID " + session.getId() + " which does not contain a saved request. Attribute names are: " + String.valueOf(list)));
            }
        }
        SavedRequest savedRequest = this.requestCache.getRequest(request, null);
        if (savedRequest == null) {
            throw new CookiesNotSupportedException();
        }
        Map parameterMap = savedRequest.getParameterMap();
        Map<String, List> parameters = parameterMap.keySet().stream().collect(Collectors.toMap(key -> key, key -> Arrays.asList((String[])parameterMap.get(key))));
        List clientIds = parameters.get("client_id");
        String string = clientId = CollectionUtils.isEmpty((Collection)clientIds) ? null : (String)clientIds.get(0);
        if (!StringUtils.hasText((String)clientId)) {
            throw new UnknownClientException(String.format("client_id parameter missing in parameters: %s", parameters));
        }
        OpenIDClient openIDClient = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(clientId).orElseThrow(() -> new UnknownClientException(clientId));
        List userCode = parameters.get("user_code");
        if (!CollectionUtils.isEmpty((Collection)userCode)) {
            List grants = openIDClient.getGrants();
            if (!grants.contains(GrantType.DEVICE_CODE.getValue())) {
                throw new InvalidGrantException(String.format("Grant types %s for client %s does not allow for device code flow", grants, openIDClient.getClientId()));
            }
        } else {
            List redirectUris = parameters.get("redirect_uri");
            URI redirectURI = CollectionUtils.isEmpty((Collection)redirectUris) ? null : URI.create((String)redirectUris.get(0));
            AuthorizationEndpoint.validateRedirectionURI((URI)redirectURI, (OpenIDClient)openIDClient);
            request.setAttribute(REDIRECT_URI_VALID, (Object)true);
            AuthorizationRequest authorizationRequest = null;
            try {
                authorizationRequest = AuthorizationRequest.parse(parameters);
            }
            catch (com.nimbusds.oauth2.sdk.ParseException e) {
                throw new WrappingException(e.getMessage());
            }
            this.validateAuthorizationRequest(authorizationRequest, openIDClient);
        }
        authnRequest.setID("ARQ" + UUID.randomUUID().toString().substring(1));
        this.saveAuthenticationRequestUrl(savedRequest, authnRequest, new ClientID(clientId));
        try {
            this.enhanceAuthenticationRequest(authnRequest, parameters);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new WrappingException(e.getMessage());
        }
    }

    private void validateAuthorizationRequest(AuthorizationRequest authorizationRequest, OpenIDClient openIDClient) {
        ClientID clientID = authorizationRequest.getClientID();
        MDCContext.mdcContext((String[])new String[]{"action", "Authorization", "clientId", clientID.getValue()});
        AuthorizationEndpoint.validateScopes((OpenIDClientRepository)this.openIDClientRepository, (Scope)authorizationRequest.getScope(), (OpenIDClient)openIDClient);
        AuthorizationEndpoint.validateGrantType((AuthorizationRequest)authorizationRequest, (OpenIDClient)openIDClient);
    }

    private String param(String name, Map<String, List<String>> request) {
        List<String> values = request.get(name);
        return CollectionUtils.isEmpty(values) ? null : values.get(0);
    }

    private void enhanceAuthenticationRequest(AuthnRequest authnRequest, Map<String, List<String>> request) throws com.nimbusds.oauth2.sdk.ParseException {
        String loginHint;
        String acrValues;
        String clientId = this.param("client_id", request);
        String entityId = ServiceProviderTranslation.translateClientId((String)clientId);
        authnRequest.setScoping(this.getScoping(entityId));
        String prompt = AuthorizationEndpoint.validatePrompt(request);
        authnRequest.setForceAuthn(Boolean.valueOf(prompt != null && prompt.contains("login")));
        if (!authnRequest.isForceAuthn().booleanValue() && StringUtils.hasText((String)this.param("max_age", request))) {
            authnRequest.setForceAuthn(Boolean.valueOf(true));
        }
        if (StringUtils.hasText((String)(acrValues = this.param("acr_values", request)))) {
            List acrList = Arrays.stream(acrValues.split(" ")).map(ACR::new).collect(Collectors.toList());
            this.parseAcrValues(authnRequest, acrList);
        }
        String requestP = this.param("request", request);
        String requestUrlP = this.param("request_uri", request);
        if (StringUtils.hasText((String)requestP) || StringUtils.hasText((String)requestUrlP)) {
            OpenIDClient openIDClient = (OpenIDClient)this.openIDClientRepository.findOptionalByClientId(clientId).orElseThrow(() -> new UnknownClientException(clientId));
            if (StringUtils.hasText((String)requestUrlP) && !requestUrlP.equalsIgnoreCase(openIDClient.getJwtRequestUri())) {
                throw new JWTRequestURIMismatchException(String.format("JWT request_uri mismatch for RP %s. Requested %s, configured %s", openIDClient.getClientId(), requestUrlP, openIDClient.getJwtRequestUri()));
            }
            try {
                com.nimbusds.openid.connect.sdk.AuthenticationRequest authRequest = com.nimbusds.openid.connect.sdk.AuthenticationRequest.parse(request);
                authRequest = JWTRequest.parse((com.nimbusds.openid.connect.sdk.AuthenticationRequest)authRequest, (OpenIDClient)openIDClient);
                List acrValuesObjects = authRequest.getACRValues();
                this.parseAcrValues(authnRequest, acrValuesObjects);
                Prompt authRequestPrompt = authRequest.getPrompt();
                prompt = AuthorizationEndpoint.validatePrompt((Prompt)authRequestPrompt);
                if (!authnRequest.isForceAuthn().booleanValue() && authRequest.getMaxAge() > -1) {
                    authnRequest.setForceAuthn(Boolean.valueOf(true));
                }
                if (!authnRequest.isForceAuthn().booleanValue() && prompt != null) {
                    authnRequest.setForceAuthn(Boolean.valueOf(prompt.contains("login")));
                }
            }
            catch (JOSEException | BadJOSEException | IOException | URISyntaxException | CertificateException | ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtils.hasText((String)(loginHint = this.param("login_hint", request)))) {
            loginHint = URLDecoder.decode(loginHint, Charset.defaultCharset());
            IDPList idpList = this.addIdpEntries(loginHint);
            Scoping scoping = authnRequest.getScoping();
            scoping.setIDPList(idpList);
        }
    }

    private IDPList addIdpEntries(String loginHint) {
        IDPEntryBuilder idpEntryBuilder = (IDPEntryBuilder)this.registry.getBuilderFactory().getBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
        List<IDPEntry> idpEntries = Stream.of(loginHint.split(",")).map(String::trim).filter(arg_0 -> this.isValidURI(arg_0)).map(s -> {
            IDPEntry idpEntry = idpEntryBuilder.buildObject();
            idpEntry.setProviderID(s);
            return idpEntry;
        }).toList();
        IDPList idpList = ((IDPListBuilder)this.registry.getBuilderFactory().getBuilder(IDPList.DEFAULT_ELEMENT_NAME)).buildObject();
        idpList.getIDPEntrys().addAll(idpEntries);
        return idpList;
    }

    private Scoping getScoping(String entityId) {
        ScopingBuilder scopingBuilder = (ScopingBuilder)this.registry.getBuilderFactory().getBuilder(Scoping.DEFAULT_ELEMENT_NAME);
        Scoping scoping = scopingBuilder.buildObject();
        this.addRequesterIds(entityId, scoping);
        return scoping;
    }

    private void addRequesterIds(String entityId, Scoping scoping) {
        RequesterIDBuilder requesterIDBuilder = (RequesterIDBuilder)this.registry.getBuilderFactory().getBuilder(RequesterID.DEFAULT_ELEMENT_NAME);
        RequesterID requesterID = requesterIDBuilder.buildObject();
        requesterID.setURI(entityId);
        scoping.setProxyCount(Integer.valueOf(1));
        scoping.getRequesterIDs().add(requesterID);
    }

    private boolean isValidURI(String uri) {
        try {
            return new URI(uri).isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private void saveAuthenticationRequestUrl(SavedRequest savedRequest, AuthnRequest authnRequest, ClientID clientID) {
        String id = authnRequest.getID();
        LocalDateTime ldt = LocalDateTime.now().plusHours(1L);
        Date expiresIn = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        LOG.debug((Object)("Saving AuthenticationRequest with redirectURL: " + savedRequest.getRedirectUrl()));
        this.authenticationRequestRepository.insert((Object)new AuthenticationRequest(id, expiresIn, clientID != null ? clientID.getValue() : null, savedRequest.getRedirectUrl()));
    }

    private void parseAcrValues(AuthnRequest authnRequest, List<ACR> acrValuesObjects) {
        if (!CollectionUtils.isEmpty(acrValuesObjects)) {
            RequestedAuthnContextBuilder requestedAuthnContextBuilder = (RequestedAuthnContextBuilder)this.registry.getBuilderFactory().getBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
            RequestedAuthnContext requestedAuthnContext = requestedAuthnContextBuilder.buildObject();
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            AuthnContextClassRefBuilder authnContextClassRefBuilder = (AuthnContextClassRefBuilder)this.registry.getBuilderFactory().getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
            List<AuthnContextClassRef> authnContextClassRefs = acrValuesObjects.stream().map(acr -> {
                AuthnContextClassRef authnContextClassRef = authnContextClassRefBuilder.buildObject();
                authnContextClassRef.setURI(acr.getValue());
                return authnContextClassRef;
            }).toList();
            requestedAuthnContext.getAuthnContextClassRefs().addAll(authnContextClassRefs);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        }
    }
}

