/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import oidc.model.User;
import oidc.repository.UserRepository;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.io.IOUtils;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectBuilder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class FakeSamlAuthenticationFilter
extends GenericFilterBean {
    private final UserRepository userRepository;
    private final ObjectMapper objectMapper;
    private final List<String> authorizeEndpoints = Arrays.asList("oidc/authorize", "oidc/consent", "oidc/device_authorize");
    private final XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);

    public FakeSamlAuthenticationFilter(UserRepository userRepository, ObjectMapper objectMapper) {
        this.userRepository = userRepository;
        this.objectMapper = objectMapper;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        boolean authorizeFlow = this.authorizeEndpoints.stream().anyMatch(requestURI::contains);
        if (!(!authorizeFlow || authentication != null && authentication.isAuthenticated() || authentication instanceof OidcSamlAuthentication)) {
            User user = this.getUser(this.objectMapper, request);
            this.userRepository.deleteAll();
            this.userRepository.insert((Object)user);
            request.setAttribute("REDIRECT_URI_VALID", (Object)true);
            OidcSamlAuthentication samlAuthentication = new OidcSamlAuthentication(this.getAssertion(), user, "http://localhost");
            SecurityContextHolder.getContext().setAuthentication((Authentication)samlAuthentication);
        }
        chain.doFilter(request, response);
    }

    public User getUser(ObjectMapper objectMapper, ServletRequest request) throws IOException {
        String userParameter = request.getParameter("user");
        String path = String.format("data/%s.json", StringUtils.hasText((String)userParameter) ? userParameter : "user");
        return (User)objectMapper.readValue(IOUtils.toString((InputStream)new ClassPathResource(path).getInputStream(), (Charset)Charset.defaultCharset()), User.class);
    }

    public Assertion getAssertion() {
        AssertionBuilder assertionBuilder = (AssertionBuilder)this.registry.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = assertionBuilder.buildObject();
        SubjectBuilder subjectBuilder = (SubjectBuilder)this.registry.getBuilderFactory().getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = subjectBuilder.buildObject();
        NameIDBuilder nameIDBuilder = (NameIDBuilder)this.registry.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = nameIDBuilder.buildObject();
        nameID.setValue("urn:collab:person:example.com:admin");
        subject.setNameID(nameID);
        assertion.setSubject(subject);
        return assertion;
    }
}

