/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import oidc.model.AuthorizationCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class ConcurrentAuthorizationCodeRepository {
    private final FindAndModifyOptions options = FindAndModifyOptions.options().returnNew(true);
    private final MongoTemplate mongoTemplate;

    @Autowired
    public ConcurrentAuthorizationCodeRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public AuthorizationCode findByCodeNotAlreadyUsedAndMarkAsUsed(String code) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("alreadyUsed").is((Object)false));
        return (AuthorizationCode)this.mongoTemplate.findAndModify(query, (UpdateDefinition)Update.update((String)"alreadyUsed", (Object)true), this.options, AuthorizationCode.class);
    }
}

