/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import oidc.exceptions.InvalidGrantException;
import oidc.log.MDCContext;
import oidc.model.AccessToken;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.secure.TokenGenerator;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoEndpoint {
    private final AccessTokenRepository accessTokenRepository;
    private final TokenGenerator tokenGenerator;

    public UserInfoEndpoint(AccessTokenRepository accessTokenRepository, TokenGenerator tokenGenerator) {
        this.accessTokenRepository = accessTokenRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @GetMapping(value={"oidc/userinfo"})
    public ResponseEntity<Map<String, Object>> getUserInfo(HttpServletRequest request) throws IOException, ParseException, java.text.ParseException {
        return this.userInfo(request);
    }

    @PostMapping(value={"oidc/userinfo"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Map<String, Object>> postUserInfo(HttpServletRequest request) throws ParseException, IOException, java.text.ParseException {
        return this.userInfo(request);
    }

    private ResponseEntity<Map<String, Object>> userInfo(HttpServletRequest request) throws ParseException, IOException, java.text.ParseException {
        HTTPRequest httpRequest = JakartaServletUtils.createHTTPRequest((HttpServletRequest)request);
        if (request.getMethod().equalsIgnoreCase("GET")) {
            httpRequest.setEntityContentType(null);
        }
        UserInfoRequest userInfoRequest = UserInfoRequest.parse((HTTPRequest)httpRequest);
        String accessTokenValue = userInfoRequest.getAccessToken().getValue();
        MDCContext.mdcContext((String[])new String[]{"action", "Userinfo", "accessTokenValue", accessTokenValue});
        Optional optionalSignedJWT = this.tokenGenerator.parseAndValidateSignedJWT(accessTokenValue);
        if (!optionalSignedJWT.isPresent()) {
            return this.errorResponse("Access Token not found");
        }
        SignedJWT signedJWT = (SignedJWT)optionalSignedJWT.get();
        String jwtId = signedJWT.getJWTClaimsSet().getJWTID();
        Optional optionalAccessToken = this.accessTokenRepository.findByJwtId(jwtId);
        if (!optionalAccessToken.isPresent()) {
            return this.errorResponse("Access Token not found");
        }
        AccessToken accessToken = (AccessToken)optionalAccessToken.get();
        if (accessToken.isExpired(Clock.systemDefaultZone())) {
            return this.errorResponse("Access Token expired");
        }
        if (accessToken.isClientCredentials()) {
            throw new InvalidGrantException("UserEndpoint not allowed for Client Credentials");
        }
        User user = this.tokenGenerator.decryptAccessTokenWithEmbeddedUserInfo(signedJWT);
        MDCContext.mdcContext((User)user, (String[])new String[0]);
        Map attributes = user.getAttributes();
        List acrClaims = user.getAcrClaims();
        if (!CollectionUtils.isEmpty((Collection)acrClaims)) {
            attributes.put("acr", String.join((CharSequence)" ", acrClaims));
        }
        attributes.put("authenticating_authority", user.getAuthenticatingAuthority());
        attributes.put("updated_at", user.getUpdatedAt());
        attributes.put("sub", user.getSub());
        return ResponseEntity.ok(new TreeMap(attributes));
    }

    private ResponseEntity<Map<String, Object>> errorResponse(String errorDescription) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("error", "invalid_token");
        body.put("error_description", errorDescription);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(body);
    }
}

