/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.nio.charset.Charset;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="access_tokens")
public class AccessToken {
    @Id
    private String id;
    private String jwtId;
    private String sub;
    private String clientId;
    private List<String> scopes;
    private String signingKeyId;
    private Date expiresIn;
    private Date createdAt;
    private boolean clientCredentials;
    private String authorizationCodeId;
    private String unspecifiedUrnHash;
    private String value;

    public AccessToken(String jwtId, String sub, String clientId, List<String> scopes, String signingKeyId, Date expiresIn, boolean clientCredentials, String authorizationCodeId, String unspecifiedUrnHash) {
        this.jwtId = jwtId;
        this.sub = sub;
        this.clientId = clientId;
        this.scopes = scopes;
        this.signingKeyId = signingKeyId;
        this.expiresIn = expiresIn != null ? expiresIn : Date.from(LocalDateTime.now().plusSeconds(3600L).atZone(ZoneId.systemDefault()).toInstant());
        this.clientCredentials = clientCredentials;
        this.authorizationCodeId = authorizationCodeId;
        this.unspecifiedUrnHash = unspecifiedUrnHash;
        this.createdAt = new Date();
    }

    public static String computeInnerValueFromJWT(String value) {
        return UUID.nameUUIDFromBytes(value.getBytes(Charset.defaultCharset())).toString();
    }

    @Transient
    public boolean isExpired(Clock clock) {
        return clock.instant().isAfter(this.expiresIn.toInstant());
    }

    public String getId() {
        return this.id;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public String getSub() {
        return this.sub;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public boolean isClientCredentials() {
        return this.clientCredentials;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getSigningKeyId() {
        return this.signingKeyId;
    }

    public String getUnspecifiedUrnHash() {
        return this.unspecifiedUrnHash;
    }

    public String getValue() {
        return this.value;
    }

    @Generated
    public AccessToken() {
    }
}

