/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.net.URI;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class ProvidedRedirectURI {
    private final String redirectURI;
    private final URI me;
    private final boolean strictRedirectUriCheck = true;

    public ProvidedRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        this.me = URI.create(redirectURI);
    }

    public boolean equalsWithLiteralCheckRequired(String uri) {
        URI that = URI.create(uri);
        if (StringUtils.hasText((String)that.getFragment())) {
            return false;
        }
        boolean equals = Objects.equals(that.getScheme(), this.me.getScheme()) && Objects.equals(that.getHost(), this.me.getHost()) && Objects.equals(that.getPath(), this.me.getPath());
        boolean bl = equals = equals && Objects.equals(that.getQuery(), this.me.getQuery());
        return this.literalCheckRequired() ? equals && that.getPort() == this.me.getPort() : equals;
    }

    private boolean literalCheckRequired() {
        String host = this.me.getHost();
        return !"127.0.0.1".equals(host) && !"localhost".equals(host) && !"[::1]".equals(host);
    }

    public String toString() {
        return this.redirectURI;
    }

    @Generated
    public String getRedirectURI() {
        return this.redirectURI;
    }

    @Generated
    public URI getMe() {
        return this.me;
    }

    @Generated
    public boolean isStrictRedirectUriCheck() {
        Objects.requireNonNull(this);
        return true;
    }
}

