/*
 * Decompiled with CFR 0.152.
 */
package oidc.mongo;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongoHealthIndicator
implements HealthIndicator {
    private MongoTemplate mongoTemplate;

    @Autowired
    public MongoHealthIndicator(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public Health health() {
        String collections = StreamSupport.stream(this.mongoTemplate.getDb().listCollectionNames().spliterator(), false).collect(Collectors.joining(", "));
        return Health.up().withDetail("Collections", (Object)collections).build();
    }
}

