/*
 * Decompiled with CFR 0.152.
 */
package provisioning.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import provisioning.model.HttpMethod;
import provisioning.model.Provisioning;
import provisioning.model.ProvisioningType;
import provisioning.model.ResourceType;
import provisioning.repository.ProvisioningRepository;

@RestController
@RequestMapping(value={"/graph"}, produces={"application/json"})
public class GraphController {
    private static final Log LOG = LogFactory.getLog(GraphController.class);
    private final ProvisioningRepository provisioningRepository;
    private final ObjectMapper objectMapper;
    private final String inviteServerMSRedirectUrl;
    private final String mockServerBaseUrl;

    @Autowired
    public GraphController(ProvisioningRepository provisioningRepository, ObjectMapper objectMapper, @Value(value="${invite-server-ms-redirect-url}") String inviteServerMSRedirectUrl, @Value(value="${mock-server-base-url}") String mockServerBaseUrl) {
        this.provisioningRepository = provisioningRepository;
        this.objectMapper = objectMapper;
        this.inviteServerMSRedirectUrl = inviteServerMSRedirectUrl;
        this.mockServerBaseUrl = mockServerBaseUrl;
    }

    @PostMapping(value={"/users"})
    public ResponseEntity<Map<String, Object>> createUser(@RequestBody Map<String, Object> user) {
        LOG.info((Object)("/graph/users POST " + String.valueOf(user)));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.graph, this.objectMapper.valueToTree(user), HttpMethod.POST, ResourceType.USERS, "/graph/users"));
        String inviteRedirectUrl = (String)user.get("inviteRedirectUrl");
        List<String> parts = List.of(inviteRedirectUrl.split("/"));
        String manageId = parts.get(parts.size() - 2);
        String userId = parts.get(parts.size() - 1);
        String id = UUID.randomUUID().toString();
        return ResponseEntity.ok(Map.of("invitedUser", Map.of("id", id), "inviteRedeemUrl", String.format("%s/graph/accept/%s/%s", this.mockServerBaseUrl, manageId, userId), "id", id));
    }

    @GetMapping(value={"/users"})
    public ResponseEntity<Map<String, Object>> getUser() {
        LOG.info((Object)"/graph/users GET ");
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.graph, this.objectMapper.valueToTree(null), HttpMethod.GET, ResourceType.USERS, "/graph/users"));
        return ResponseEntity.ok(Map.of("id", UUID.randomUUID().toString()));
    }

    @DeleteMapping(value={"/users"})
    public ResponseEntity<Void> deleteUser() {
        LOG.info((Object)"/graph/users DELETE ");
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.graph, this.objectMapper.valueToTree(null), HttpMethod.DELETE, ResourceType.USERS, "/graph/users"));
        return ResponseEntity.status((int)201).build();
    }

    @PatchMapping(value={"/users"})
    public ResponseEntity<Map<String, Object>> updateUser(@RequestBody Map<String, Object> user) {
        LOG.info((Object)("/graph/users PATCH " + String.valueOf(user)));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.graph, this.objectMapper.valueToTree(user), HttpMethod.PATCH, ResourceType.USERS, "/graph/users"));
        return ResponseEntity.ok(user);
    }

    @GetMapping(value={"/accept/{manageId}/{userId}"})
    public View accept(@PathVariable(value="manageId") String manageId, @PathVariable(value="userId") String userId) {
        LOG.info((Object)"/graph/accept GET ");
        return new RedirectView(String.format("%s/%s/%s", this.inviteServerMSRedirectUrl, manageId, userId));
    }
}

