/*
 * Decompiled with CFR 0.152.
 */
package voot.api;

import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import voot.AccessDeniedException;
import voot.ExternalGroupsService;
import voot.ResourceNotFoundException;
import voot.model.Group;
import voot.model.Member;
import voot.model.User;
import voot.util.UrnUtils;

@RestController
public class VootController {
    private static final Logger LOG = LoggerFactory.getLogger(VootController.class);
    private final ExternalGroupsService externalGroupsService;

    @Autowired
    public VootController(ExternalGroupsService externalGroupsService) {
        this.externalGroupsService = externalGroupsService;
    }

    @RequestMapping(value={"/me/groups"})
    public Set<Group> myGroups(User user) {
        String schacHome = user.getSchacHomeOrganization();
        String clientId = user.getClientId();
        String unspecifiedId = user.getUnspecifiedId();
        LOG.debug("me/groups on behalf of uid: {}, schacHomeOrg: {}, clientId: {}", new Object[]{unspecifiedId, schacHome, clientId});
        Set myGroups = this.externalGroupsService.getMyGroups(unspecifiedId, schacHome);
        LOG.debug("me/groups result for uid {}: {}", user.getClass(), (Object)myGroups);
        return myGroups;
    }

    @RequestMapping(value={"/me/groups/{groupId:.+}"})
    public Group specificGroupMembership(@PathVariable String groupId, User user) {
        String schacHome = user.getSchacHomeOrganization();
        String clientId = user.getClientId();
        String unspecifiedId = user.getUnspecifiedId();
        LOG.debug("groups/{} on behalf of uid {}, schacHomeOrg: {}, clientId {}", new Object[]{groupId, unspecifiedId, schacHome, clientId});
        if (!UrnUtils.isFullyQualifiedGroupName((String)groupId)) {
            throw new IllegalArgumentException(groupId);
        }
        Optional group = this.externalGroupsService.getMyGroupById(unspecifiedId, groupId);
        LOG.debug("groups/{} result for uid {}: {}", new Object[]{groupId, unspecifiedId, group});
        return (Group)group.orElseThrow(ResourceNotFoundException::new);
    }

    @RequestMapping(value={"/internal/groups/{userId:.+}/{groupId:.+}"})
    public Group internalSpecificGroup(@PathVariable String userId, @PathVariable String groupId, User user) {
        String clientId = user.getClientId();
        LOG.debug("internal/groups/{}/{}, clientId {}", new Object[]{userId, groupId, clientId});
        this.assertClientCredentialsClient(user);
        Optional group = this.externalGroupsService.getMyGroupById(userId, groupId);
        LOG.debug("groups/{} result: {}", (Object)groupId, (Object)group);
        return (Group)group.orElseThrow(ResourceNotFoundException::new);
    }

    @RequestMapping(value={"/internal/groups/{userId:.+}"})
    public Set<Group> internalGroups(@PathVariable String userId, User user) {
        String clientId = user.getClientId();
        LOG.debug("internal/groups/{}, clientId {}", (Object)userId, (Object)clientId);
        this.assertClientCredentialsClient(user);
        String schacHome = UrnUtils.getSchacHomeFromPersonUrn((String)userId);
        Set myGroups = this.externalGroupsService.getMyGroups(userId, schacHome);
        LOG.debug("internal/groups/{} result: {}", (Object)userId, (Object)myGroups);
        return myGroups;
    }

    @RequestMapping(value={"/internal/external-groups/{userId:.+}"})
    public Set<Group> externalGroups(@PathVariable String userId, User user) {
        String clientId = user.getClientId();
        LOG.debug("internal/external-groups/{}, clientId {}", (Object)userId, (Object)clientId);
        this.assertClientCredentialsClient(user);
        String schacHome = UrnUtils.getSchacHomeFromPersonUrn((String)userId);
        Set groups = this.externalGroupsService.getMyExternalGroups(userId, schacHome);
        LOG.debug("internal/external-groups/{} result: {}", (Object)userId, (Object)groups);
        return groups;
    }

    @RequestMapping(value={"/internal/all-groups"})
    public Set<Group> allGroups(User user) {
        String clientId = user.getClientId();
        LOG.debug("internal/all-groups, clientId {}", (Object)clientId);
        this.assertClientCredentialsClient(user);
        Set groups = this.externalGroupsService.getAllGroups();
        LOG.debug("internal/all-groupsresult: {}", (Object)groups.size());
        return groups;
    }

    @RequestMapping(value={"/members/{groupId:.+}"})
    public Set<Member> members(@PathVariable String groupId, User user) {
        String clientId = user.getClientId();
        LOG.debug("members/{}, accessToken: {}, clientId {}", (Object)groupId, (Object)clientId);
        this.assertClientCredentialsClient(user);
        Set members = this.externalGroupsService.getMembers(groupId);
        LOG.debug("/members/{} result: {}", (Object)groupId, (Object)members);
        return members;
    }

    @RequestMapping(value={"/members/{personId:.+}/{groupId:.+}"})
    public Set<Member> membersIncExternalMembers(@PathVariable String personId, @PathVariable String groupId, User user) {
        String clientId = user.getClientId();
        LOG.debug("members/{}, clientId {}", (Object)groupId, (Object)clientId);
        this.assertClientCredentialsClient(user);
        Set members = this.externalGroupsService.getMembers(personId, groupId);
        LOG.debug("/members/{}/{} result: {}", new Object[]{personId, groupId, members});
        return members;
    }

    private void assertClientCredentialsClient(User user) {
        if (StringUtils.hasText((String)user.getUnspecifiedId())) {
            throw new AccessDeniedException(String.format("ClientCredentials grant type required. Unspecified ID is %s", user.getUnspecifiedId()));
        }
    }
}

