/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.FullSearchQueryParser;
import access.api.Results;
import access.api.UserAccessRights;
import access.config.Config;
import access.exception.NotFoundException;
import access.model.Authority;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.OrganizationStatus;
import access.model.User;
import access.repository.OrganizationMembershipRepository;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/organizations"}, produces={"application/json"})
@Transactional
@EnableConfigurationProperties(value={Config.class})
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class OrganizationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(OrganizationController.class);
    private final OrganizationRepository organizationRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;
    private final Config config;
    private final UserRepository userRepository;

    @Autowired
    public OrganizationController(OrganizationRepository organizationRepository, OrganizationMembershipRepository organizationMembershipRepository, UserRepository userRepository, Config config) {
        this.organizationRepository = organizationRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
        this.config = config;
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/find/{id}"})
    public ResponseEntity<Organization> find(User user, @PathVariable(value="id") Long id) {
        LOG.debug((Object)("/find Organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findDetailsById(id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        this.confirmOrganizationMembership(user, organization, Authority.MEMBER);
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/search/paginated"})
    public ResponseEntity<Page<Map<String, Object>>> search(@Parameter(hidden=true) User user, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        LOG.debug((Object)String.format("/search for user %s", user.getEduPersonPrincipalName()));
        this.confirmSuperUser(user);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        Page usersPage = this.organizationRepository.searchByPageWithKeyword(FullSearchQueryParser.parse((String)query), (Pageable)pageable);
        return ResponseEntity.ok((Object)usersPage);
    }

    @GetMapping(value={"/users/{id}"})
    public ResponseEntity<Organization> light(User user, @PathVariable(value="id") Long id) {
        LOG.debug((Object)("/find Organization light by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findUsersById(id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        this.confirmOrganizationMembership(user, organization, Authority.GUEST);
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/light/{id}"})
    public ResponseEntity<Organization> light(@PathVariable(value="id") Long id) {
        LOG.debug((Object)"/light");
        Organization organization = (Organization)this.organizationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/invitation/{id}"})
    public ResponseEntity<Organization> name(@PathVariable(value="id") Long id) {
        LOG.debug((Object)"/name");
        Organization organization = (Organization)this.organizationRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("Organisation not found"));
        Hibernate.initialize((Object)organization.getApplications());
        return ResponseEntity.ok((Object)organization);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<Organization>> search(@RequestParam(value="query") String query) {
        LOG.debug((Object)"/search");
        return ResponseEntity.ok((Object)this.organizationRepository.findByNameContainingIgnoreCase(query));
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Organization> create(User user, @RequestBody @Validated Organization organization) {
        String name = organization.getName();
        Organization newOrganization = this.createOrganization(user, name);
        Organization savedOrganization = (Organization)this.organizationRepository.save((Object)newOrganization);
        OrganizationMembership organizationMembership = new OrganizationMembership(user, savedOrganization, Authority.ADMIN);
        this.organizationMembershipRepository.save((Object)organizationMembership);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedOrganization);
    }

    @PutMapping(value={"/approve/{organizationId}"})
    public ResponseEntity<Organization> approve(User user, @PathVariable(value="organizationId") Long organizationId) {
        this.confirmSuperUser(user);
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        organization.setStatus(OrganizationStatus.APPROVED);
        Organization savedOrganization = (Organization)this.organizationRepository.save((Object)organization);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)savedOrganization);
    }

    @DeleteMapping(value={"", "/{organizationId}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="organizationId") Long organizationId) {
        LOG.debug((Object)("/delete organization by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organization not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        this.organizationRepository.deleteOrganizationById(organizationId);
        return Results.deleteResult();
    }

    private Organization createOrganization(User user, String name) {
        String orgSchacHomeOrganization = this.getOrgSchacHomeOrganization(user, name);
        return new Organization(name, orgSchacHomeOrganization);
    }

    private String getOrgSchacHomeOrganization(User user, String name) {
        String orgSchacHomeOrganization;
        String schacHomeOrganization = user.getSchacHomeOrganization().toLowerCase();
        if (this.config.getEduIdSchacHomeOrganization().equals(schacHomeOrganization)) {
            String normalizedName = name.replaceAll("[^a-zA-Z_ ]", "").trim().replaceAll(" ", "_").toLowerCase();
            orgSchacHomeOrganization = String.format("%s.%s", normalizedName, this.config.getEduIdSchacHomeOrganization());
        } else {
            orgSchacHomeOrganization = schacHomeOrganization;
        }
        return orgSchacHomeOrganization;
    }
}

