/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.model.Application;
import access.model.Invitation;
import access.model.JoinRequest;
import access.model.NameHolder;
import access.model.OrganizationMembership;
import access.model.OrganizationStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.annotations.Formula;

@Entity(name="organizations")
public class Organization
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="schac_home_organization")
    private String schacHomeOrganization;
    @Column(name="created_at")
    private Instant createdAt;
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private OrganizationStatus status = OrganizationStatus.PENDING_APPROVAL;
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<Application> applications = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<OrganizationMembership> organizationMemberships = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<JoinRequest> joinRequests = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<Invitation> invitations = new HashSet();
    @Formula(value="(SELECT COUNT(*) FROM organization_memberships om WHERE om.organization_id=id)")
    private Long memberCount;
    @Formula(value="(SELECT COUNT(*) FROM applications a WHERE a.organization_id=id)")
    private Long applicationCount;

    public Organization(String name, String schacHomeOrganization) {
        this.name = name;
        this.schacHomeOrganization = schacHomeOrganization;
        this.createdAt = Instant.now();
    }

    @JsonIgnore
    public OrganizationMembership addOrganizationMembership(OrganizationMembership organizationMembership) {
        this.organizationMemberships.add(organizationMembership);
        organizationMembership.setOrganization(this);
        return organizationMembership;
    }

    @JsonIgnore
    public void removeApplication(Application application) {
        Set newApplications = this.applications.stream().filter(app -> !app.getId().equals(application.getId())).collect(Collectors.toSet());
        this.applications.clear();
        this.applications.addAll(newApplications);
    }

    @JsonIgnore
    public void removeJoinRequest(JoinRequest joinRequest) {
        Set newJoinRequests = this.joinRequests.stream().filter(jr -> !jr.getId().equals(joinRequest.getId())).collect(Collectors.toSet());
        this.joinRequests.clear();
        this.joinRequests.addAll(newJoinRequests);
    }

    @Generated
    public Organization() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public OrganizationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Set<Application> getApplications() {
        return this.applications;
    }

    @Generated
    public Set<OrganizationMembership> getOrganizationMemberships() {
        return this.organizationMemberships;
    }

    @Generated
    public Set<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    @Generated
    public Set<Invitation> getInvitations() {
        return this.invitations;
    }

    @Generated
    public Long getMemberCount() {
        return this.memberCount;
    }

    @Generated
    public Long getApplicationCount() {
        return this.applicationCount;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setStatus(OrganizationStatus status) {
        this.status = status;
    }

    @Generated
    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }

    @Generated
    public void setOrganizationMemberships(Set<OrganizationMembership> organizationMemberships) {
        this.organizationMemberships = organizationMemberships;
    }

    @Generated
    public void setJoinRequests(Set<JoinRequest> joinRequests) {
        this.joinRequests = joinRequests;
    }

    @Generated
    public void setInvitations(Set<Invitation> invitations) {
        this.invitations = invitations;
    }

    @Generated
    public void setMemberCount(Long memberCount) {
        this.memberCount = memberCount;
    }

    @Generated
    public void setApplicationCount(Long applicationCount) {
        this.applicationCount = applicationCount;
    }
}

