/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.FullSearchQueryParser;
import access.api.Results;
import access.api.UserAccessRights;
import access.config.Config;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.mail.MailBox;
import access.manage.Manage;
import access.model.Authority;
import access.model.Institution;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@RequestMapping(value={"/api/v1/users"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final Config config;
    private final UserRepository userRepository;
    private final OrganizationRepository organizationRepository;
    private final Manage manage;
    private final MailBox mailBox;

    @Autowired
    public UserController(Config config, UserRepository userRepository, OrganizationRepository organizationRepository, Manage manage, MailBox mailBox) throws IOException {
        this.config = config;
        this.userRepository = userRepository;
        this.organizationRepository = organizationRepository;
        this.manage = manage;
        this.mailBox = mailBox;
    }

    @GetMapping(value={"/config"})
    public ResponseEntity<Config> config(User user) {
        LOG.debug((Object)"/config");
        Config result = new Config(this.config);
        result.withAuthenticated(user != null && user.getId() != null).withName(user != null ? user.getName() : null).withStats(this.manage.stats());
        if (user != null) {
            this.verifyMissingAttributes(user, result);
        }
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"login"})
    public View login() {
        LOG.debug((Object)"/login");
        return new RedirectView(this.config.getClientUrl(), false);
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<User> me(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/me for user %s", user.getEduPersonPrincipalName()));
        User userFromDB = (User)this.userRepository.findDetailsById(user.getId()).orElseThrow(() -> new NotFoundException("User not found"));
        String schacHomeOrganization = userFromDB.getSchacHomeOrganization();
        if (userFromDB.getOrganizationMemberships().isEmpty() && !schacHomeOrganization.equals(this.config.getEduIdSchacHomeOrganization())) {
            Optional organizationOptional = this.organizationRepository.findBySchacHomeOrganization(schacHomeOrganization);
            organizationOptional.ifPresent(organization -> {
                userFromDB.addOrganizationMembership(new OrganizationMembership(userFromDB, organization, Authority.MEMBER));
                this.userRepository.save((Object)userFromDB);
            });
            Institution institution = user.getInstitution();
            if (userFromDB.isInstitutionAdmin() && institution != null) {
                userFromDB.setInstitution(institution);
                if (organizationOptional.isEmpty()) {
                    String name = institution.getOrganizationName();
                    Organization organization2 = new Organization(name, schacHomeOrganization);
                    this.organizationRepository.save((Object)organization2);
                    userFromDB.addOrganizationMembership(new OrganizationMembership(userFromDB, organization2, Authority.ADMIN));
                    this.userRepository.save((Object)userFromDB);
                }
            }
        }
        userFromDB.setExternalUser(this.config.getEduIdSchacHomeOrganization().equalsIgnoreCase(userFromDB.getSchacHomeOrganization()));
        return ResponseEntity.ok((Object)userFromDB);
    }

    @GetMapping(value={"/other/{id}"})
    public ResponseEntity<User> details(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/other/%s for user $s", id, user.getEduPersonPrincipalName()));
        if (!user.isSuperUser()) {
            throw new NotAllowedException("Not allowed endpoint by" + String.valueOf(user));
        }
        User other = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("User not found"));
        return ResponseEntity.ok((Object)other);
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<Map<String, Integer>> logout(HttpServletRequest request) {
        LOG.debug((Object)"/logout");
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return Results.okResult();
    }

    @PostMapping(value={"/feedback"})
    public ResponseEntity<Map<String, Integer>> feedback(User user, @RequestBody Map<String, String> body) {
        LOG.debug((Object)("/feedback from " + user.getEmail()));
        String message = body.get("message");
        if (StringUtils.hasText((String)message)) {
            this.mailBox.sendFeedbackMail(user, message);
        }
        return Results.okResult();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<Map<String, Object>>> search(@Parameter(hidden=true) User user, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        LOG.debug((Object)String.format("/search for user %s", user.getEduPersonPrincipalName()));
        this.confirmSuperUser(user);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        String parsedQuery = FullSearchQueryParser.parse((String)query);
        Page usersPage = this.userRepository.searchByPageWithKeyword(parsedQuery, (Pageable)pageable);
        return ResponseEntity.ok((Object)usersPage);
    }

    private void verifyMissingAttributes(User user, Config result) {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (!StringUtils.hasText((String)user.getEmail())) {
            missingAttributes.add("email");
        }
        if (!StringUtils.hasText((String)user.getSchacHomeOrganization())) {
            missingAttributes.add("schacHomeOrganization");
        }
        if (!StringUtils.hasText((String)user.getFamilyName())) {
            missingAttributes.add("familyName");
        }
        if (!StringUtils.hasText((String)user.getGivenName())) {
            missingAttributes.add("givenName");
        }
        if (!missingAttributes.isEmpty()) {
            result.withMissingAttributes(missingAttributes);
        }
    }
}

