/*
 * Decompiled with CFR 0.152.
 */
package access.repository;

import access.model.Organization;
import access.model.OrganizationStatus;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface OrganizationRepository
extends JpaRepository<Organization, Long> {
    public List<Organization> findByNameContainingIgnoreCase(String var1);

    public Optional<Organization> findBySchacHomeOrganization(String var1);

    public List<Organization> findByStatus(OrganizationStatus var1);

    @EntityGraph(attributePaths={"applications.connections", "organizationMemberships.user", "invitations.invitee", "joinRequests.user"})
    public Optional<Organization> findDetailsById(Long var1);

    @EntityGraph(attributePaths={"organizationMemberships.user"})
    public Optional<Organization> findUsersById(Long var1);

    @Modifying
    @Query(value="DELETE FROM organizations WHERE id = ?1", nativeQuery=true)
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void deleteOrganizationById(Long var1);

    @Query(value=" SELECT org.id, org.name, org.schac_home_organization, org.status, org.created_at,\n    (SELECT COUNT(*) FROM organization_memberships om WHERE om.organization_id = org.id) as memberCount,\n    (SELECT COUNT(*) FROM applications a WHERE a.organization_id = org.id) as applicationCount\n  FROM organizations org WHERE MATCH (name, schac_home_organization) against (?1  IN BOOLEAN MODE)\n", countQuery="SELECT count(*) FROM organizations WHERE MATCH (name, schac_home_organization) against (?1  IN BOOLEAN MODE)", nativeQuery=true)
    public Page<Map<String, Object>> searchByPageWithKeyword(String var1, Pageable var2);
}

