/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.exception.InvalidInputException;
import access.manage.ChangeRequest;
import access.manage.Manage;
import access.manage.MetaData;
import access.manage.MetaDataFeedParser;
import access.model.EntityType;
import access.model.Environment;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/manage"}, produces={"application/json"})
public class ManageController {
    private static final Log LOG = LogFactory.getLog(ManageController.class);
    private final MetaDataFeedParser metaDataFeedParser = new MetaDataFeedParser();
    private final Manage manage;
    private final Map<String, Object> arpInfo;
    private final List<Map<String, Object>> privacyInfo;

    public ManageController(Manage manage, ObjectMapper objectMapper) {
        this.manage = manage;
        this.arpInfo = (Map)objectMapper.readValue(new ClassPathResource("/metadata/ARP.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.privacyInfo = (List)objectMapper.readValue(new ClassPathResource("/metadata/Privacy.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GetMapping(value={"/arp"})
    public ResponseEntity<Map<String, Object>> arp() {
        LOG.debug((Object)"/arp");
        return ResponseEntity.ok((Object)this.arpInfo);
    }

    @GetMapping(value={"/privacy"})
    public ResponseEntity<List<Map<String, Object>>> privacy() {
        LOG.debug((Object)"/privacy");
        return ResponseEntity.ok((Object)this.privacyInfo);
    }

    @PostMapping(value={"/parse"})
    public ResponseEntity<List<MetaData>> parse(@RequestBody Map<String, String> requestBody) {
        ByteArrayResource resource;
        if (requestBody.containsKey("url")) {
            URL url = new URI(requestBody.get("url")).toURL();
            String protocol = url.getProtocol().toLowerCase();
            if (!List.of("http", "https").contains(protocol)) {
                throw new InvalidInputException("Not allowed protocol: " + protocol);
            }
            resource = new UrlResource(url);
        } else {
            String xml = requestBody.get("xml");
            resource = new ByteArrayResource(xml.getBytes(Charset.defaultCharset()));
        }
        List entityDescriptors = this.metaDataFeedParser.importXML((Resource)resource);
        return ResponseEntity.ok(entityDescriptors.stream().map(MetaData::new).toList());
    }

    @GetMapping(value={"/identity-providers/{environment}"})
    public ResponseEntity<List<Map<String, Object>>> identityProviders(@PathVariable(value="environment") Environment environment) {
        List providers = this.manage.providers(environment, new EntityType[]{EntityType.saml20_idp});
        return ResponseEntity.ok((Object)providers);
    }

    @PostMapping(value={"/unique-entity-id/{environment}"})
    public ResponseEntity<List<Map<String, Object>>> providersByEntityId(@PathVariable(value="environment") Environment environment, @RequestBody Map<String, String> data) {
        String entityID = data.get("entityID");
        List providers = this.manage.uniqueEntityId(environment, EntityType.saml20_sp, entityID);
        return ResponseEntity.ok((Object)providers);
    }

    @PutMapping(value={"/reject-change-request"})
    public ResponseEntity<Map<String, Integer>> rejectChangeRequest(@RequestBody ChangeRequest changeRequest) {
        this.manage.rejectChangeRequest(Environment.PROD, changeRequest);
        return Results.okResult();
    }
}

