/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.NotFoundException;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.ApplicationMembershipRepository;
import access.repository.ApplicationRepository;
import access.repository.OrganizationMembershipRepository;
import access.request.ApplicationMembershipForm;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/application_memberships"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ApplicationMembershipController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(ApplicationMembershipController.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationMembershipRepository applicationMembershipRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;

    public ApplicationMembershipController(ApplicationRepository applicationRepository, ApplicationMembershipRepository applicationMembershipRepository, OrganizationMembershipRepository organizationMembershipRepository) {
        this.applicationRepository = applicationRepository;
        this.applicationMembershipRepository = applicationMembershipRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<ApplicationMembership> create(User user, @RequestBody ApplicationMembershipForm applicationMembershipForm) {
        LOG.debug((Object)"/create");
        OrganizationMembership organizationMembership = (OrganizationMembership)this.organizationMembershipRepository.findById((Object)applicationMembershipForm.getOrganizationMembershipId()).orElseThrow(() -> new NotFoundException("OrganizationMembership not found"));
        Application application = (Application)this.applicationRepository.findById((Object)applicationMembershipForm.getApplicationId()).orElseThrow(() -> new NotFoundException("Application not found"));
        this.confirmOrganizationMembership(user, application.getOrganization(), Authority.GUEST);
        if (!application.getOrganization().getId().equals(organizationMembership.getOrganization().getId())) {
            throw new NotFoundException("Organization not found");
        }
        ApplicationMembership applicationMembership = new ApplicationMembership(application, organizationMembership);
        applicationMembership = (ApplicationMembership)this.applicationMembershipRepository.save((Object)applicationMembership);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)applicationMembership);
    }

    @DeleteMapping(value={"/{membership_id}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="membership_id") Long membershipId) {
        LOG.debug((Object)"/delete");
        ApplicationMembership applicationMembership = (ApplicationMembership)this.applicationMembershipRepository.findById((Object)membershipId).orElseThrow(() -> new NotFoundException("ApplicationMembership not found"));
        this.confirmOrganizationMembership(user, applicationMembership.getOrganizationMembership().getOrganization(), Authority.GUEST);
        this.applicationMembershipRepository.delete((Object)applicationMembership);
        return Results.deleteResult();
    }
}

