/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.S3Storage;
import access.api.UserAccessRights;
import access.exception.NotFoundException;
import access.manage.ConnectionProviderConverter;
import access.manage.Manage;
import access.manage.ManageData;
import access.model.Application;
import access.model.ApplicationMembership;
import access.model.Authority;
import access.model.ConnectionStatus;
import access.model.Environment;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.ApplicationMembershipRepository;
import access.repository.ApplicationRepository;
import access.repository.ConnectionRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/applications"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ApplicationController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(ApplicationController.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationMembershipRepository applicationMembershipRepository;
    private final ConnectionRepository connectionRepository;
    private final Manage manage;
    private final UserRepository userRepository;
    private final S3Storage s3Storage;
    private final ConnectionProviderConverter connectionProviderConverter;

    public ApplicationController(ApplicationRepository applicationRepository, ApplicationMembershipRepository applicationMembershipRepository, ConnectionRepository connectionRepository, Manage manage, UserRepository userRepository, S3Storage s3Storage, ConnectionProviderConverter connectionProviderConverter) {
        this.applicationRepository = applicationRepository;
        this.applicationMembershipRepository = applicationMembershipRepository;
        this.connectionRepository = connectionRepository;
        this.manage = manage;
        this.userRepository = userRepository;
        this.s3Storage = s3Storage;
        this.connectionProviderConverter = connectionProviderConverter;
    }

    @GetMapping(value={"/all/{organizationId}"})
    public ResponseEntity<List<Application>> allByOrganization(@PathVariable(value="organizationId") Long id, User user) {
        LOG.debug((Object)"/all");
        Set organizationMemberships = user.getOrganizationMemberships();
        Organization organization = organizationMemberships.stream().filter(membership -> membership.getOrganization().getId().equals(id)).map(membership -> membership.getOrganization()).findFirst().orElseThrow(() -> new NotFoundException("Organisation not found"));
        List applications = this.applicationRepository.findByOrganization(organization);
        return ResponseEntity.ok((Object)applications);
    }

    @GetMapping(value={"/{applicationId}"})
    public ResponseEntity<Application> find(User user, @PathVariable(value="applicationId") Long applicationId) {
        LOG.debug((Object)("/find application for " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findDetailsById(applicationId).orElseThrow(() -> new NotFoundException("Application not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationWriteAccess(user, application);
        AtomicReference latestChangedProvider = new AtomicReference();
        AtomicReference latestRevision = new AtomicReference();
        application.getConnections().stream().filter(connection -> StringUtils.hasText((String)connection.getManageIdentifier())).forEach(connection -> {
            Map provider = this.manage.providerById(connection);
            if (connection.mergeMetaData(provider, false)) {
                Map revision = (Map)provider.get("revision");
                Instant revisionCreated = Instant.parse(revision.get("created").toString());
                if (latestRevision.get() == null || revisionCreated.isAfter((Instant)latestRevision.get())) {
                    latestRevision.set(revisionCreated);
                    latestChangedProvider.set(provider);
                }
                this.connectionRepository.save(connection);
            }
            if (connection.getStatus().equals((Object)ConnectionStatus.PROD_READY)) {
                connection.convertChangeRequests(this.manage.getChangeRequests(Environment.PROD, connection));
            }
        });
        Map provider = (Map)latestChangedProvider.get();
        if (provider != null) {
            Map updatedMetaData = this.connectionProviderConverter.convertProviderToApplicationMetaData(provider);
            application.setMetaData(updatedMetaData);
            Map metaDataFields = ManageData.getMetaDataFields((Map)ManageData.getData((Map)provider));
            application.setLogoUrl(metaDataFields.getOrDefault("logo:0:url", application.getLogoUrl()));
            application.setName(metaDataFields.getOrDefault("coin:application_name", application.getName()));
            this.applicationRepository.save((Object)application);
        }
        return ResponseEntity.ok((Object)application);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Application> create(User user, @Validated @RequestBody Application application) {
        LOG.debug((Object)("/create application by " + user.getEmail()));
        Organization organization = application.getOrganization();
        this.confirmOrganizationMembership(user, organization, Authority.MEMBER);
        application.setCreatedAt(Instant.now());
        application.setCreatedBy(user.getName());
        application.setOwner(user);
        Application applicationSaved = (Application)this.applicationRepository.save((Object)application);
        Optional<OrganizationMembership> optionalOrganizationMembership = user.getOrganizationMemberships().stream().filter(organizationMembership -> organizationMembership.getOrganization().getId().equals(organization.getId())).findFirst();
        optionalOrganizationMembership.ifPresent(organizationMembership -> {
            ApplicationMembership applicationMembership = new ApplicationMembership(applicationSaved, organizationMembership);
            this.applicationMembershipRepository.save((Object)applicationMembership);
        });
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)applicationSaved);
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<Application> update(User user, @Validated @RequestBody Application applicationData) {
        LOG.debug((Object)("/update application by " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findById((Object)applicationData.getId()).orElseThrow(() -> new NotFoundException("Application not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationWriteAccess(user, application);
        boolean metaDataHasChanged = !application.getMetaData().equals(applicationData.getMetaData());
        application.merge(applicationData);
        String logoUrl = application.getLogoUrl();
        if (StringUtils.hasText((String)logoUrl) && !logoUrl.startsWith("http")) {
            String url = this.s3Storage.uploadFile(logoUrl);
            application.setLogoUrl(url);
            metaDataHasChanged = true;
        }
        if (metaDataHasChanged) {
            application.getConnections().forEach(connection -> {
                Map provider = this.manage.saveProvider(connection);
                connection.updateRemoteManageData(provider);
                this.connectionRepository.save(connection);
            });
        } else {
            Hibernate.initialize((Object)application.getConnections());
        }
        this.applicationRepository.save((Object)application);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)application);
    }

    @DeleteMapping(value={"", "/{applicationId}"})
    public ResponseEntity<Map<String, Integer>> delete(User user, @PathVariable(value="applicationId") Long applicationId) {
        LOG.debug((Object)("/delete application by " + user.getEmail()));
        Application application = (Application)this.applicationRepository.findById((Object)applicationId).orElseThrow(() -> new NotFoundException("Application not found"));
        Organization organization = application.getOrganization();
        user = this.reinitializeUser(user, this.userRepository);
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationDeleteAccess(user, application);
        organization.removeApplication(application);
        user.getOrganizationMemberships().forEach(organizationMembership -> {
            List<ApplicationMembership> applicationMemberships = organizationMembership.getApplicationMemberships().stream().filter(applicationMembership -> applicationMembership.getApplication().getId().equals(applicationId)).toList();
            organizationMembership.removeApplicationMemberships(applicationMemberships);
        });
        this.applicationRepository.deleteById((Object)application.getId());
        return Results.deleteResult();
    }
}

