/*
 * Decompiled with CFR 0.152.
 */
package access.model;

import access.manage.Contact;
import access.manage.ManageData;
import access.model.Application;
import access.model.Invitation;
import access.model.JoinRequest;
import access.model.NameHolder;
import access.model.OrganizationMembership;
import access.model.OrganizationStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.hibernate.annotations.Formula;
import org.springframework.util.CollectionUtils;

@Entity(name="organizations")
public class Organization
implements NameHolder {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    @NotNull
    private String name;
    @Column(name="schac_home_organization")
    private String schacHomeOrganization;
    @Column(name="manage_identifier")
    private String manageIdentifier;
    @Column(name="manage_version")
    private Integer manageVersion;
    @Column(name="ticket_key")
    private String ticketKey;
    @Column(name="created_at")
    private Instant createdAt;
    @Transient
    private Map<String, Object> metaData = new HashMap();
    @Enumerated(value=EnumType.STRING)
    @Column
    @NotNull
    private OrganizationStatus status = OrganizationStatus.PENDING_APPROVAL;
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<Application> applications = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<OrganizationMembership> organizationMemberships = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<JoinRequest> joinRequests = new HashSet();
    @OneToMany(mappedBy="organization", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<Invitation> invitations = new HashSet();
    @Formula(value="(SELECT COUNT(*) FROM organization_memberships om WHERE om.organization_id=id)")
    private Long memberCount;
    @Formula(value="(SELECT COUNT(*) FROM applications a WHERE a.organization_id=id)")
    private Long applicationCount;
    @Transient
    private List<Map<String, Object>> changeRequests;

    public Organization(String name, String schacHomeOrganization) {
        this.name = name;
        this.schacHomeOrganization = schacHomeOrganization;
        this.createdAt = Instant.now();
    }

    public Organization(String name, String schacHomeOrganization, String manageIdentifier, Integer manageVersion) {
        this.name = name;
        this.schacHomeOrganization = schacHomeOrganization;
        this.manageIdentifier = manageIdentifier;
        this.manageVersion = manageVersion;
        this.createdAt = Instant.now();
    }

    @JsonIgnore
    public OrganizationMembership addOrganizationMembership(OrganizationMembership organizationMembership) {
        this.organizationMemberships.add(organizationMembership);
        organizationMembership.setOrganization(this);
        return organizationMembership;
    }

    @JsonIgnore
    public void removeApplication(Application application) {
        Set newApplications = this.applications.stream().filter(app -> !app.getId().equals(application.getId())).collect(Collectors.toSet());
        this.applications.clear();
        this.applications.addAll(newApplications);
    }

    @JsonIgnore
    public void removeJoinRequest(JoinRequest joinRequest) {
        Set newJoinRequests = this.joinRequests.stream().filter(jr -> !jr.getId().equals(joinRequest.getId())).collect(Collectors.toSet());
        this.joinRequests.clear();
        this.joinRequests.addAll(newJoinRequests);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public List<Map<String, Object>> getChangeRequests() {
        return this.changeRequests;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @JsonIgnore
    public boolean mergeMetaData(Map<String, Object> provider, boolean force) {
        Integer newManageVersion = (Integer)provider.get("version");
        if (newManageVersion.equals(this.manageVersion) && !force && !CollectionUtils.isEmpty((Map)this.metaData)) {
            return false;
        }
        this.manageIdentifier = (String)provider.get("id");
        this.manageVersion = newManageVersion;
        this.metaData = new HashMap();
        Map data = ManageData.getData(provider);
        String entityID = (String)data.get("entityid");
        this.metaData.put("entityID", entityID);
        String state = (String)data.get("state");
        this.metaData.put("state", state);
        this.metaData.put("allowedall", data.get("allowedall"));
        List.of("allowedEntities", "disableConsent", "stepupEntities", "mfaEntities").forEach(key -> this.metaData.put(key, data.getOrDefault(key, List.of())));
        Map metaDataFields = ManageData.getMetaDataFields((Map)data);
        this.name = metaDataFields.getOrDefault("name:en", this.name);
        this.metaData.put("name", this.name);
        this.metaData.put("logoUrl", metaDataFields.get("logo:0:url"));
        String allKeyWords = metaDataFields.getOrDefault("keywords:0:nl", "") + String.valueOf(metaDataFields.getOrDefault("keywords:0:en", ""));
        Set keyWords = Arrays.stream(allKeyWords.split(" ")).map(String::trim).collect(Collectors.toSet());
        this.metaData.put("keyWords", keyWords);
        ArrayList contactPersons = new ArrayList();
        IntStream.of(0, 1, 2, 3, 4, 5).forEach(index -> {
            if (metaDataFields.containsKey("contacts:" + index + ":emailAddress")) {
                Contact contact = new Contact((String)metaDataFields.get("contacts:" + index + ":contactType"), (String)metaDataFields.get("contacts:" + index + ":givenName"), (String)metaDataFields.get("contacts:" + index + ":surName"), (String)metaDataFields.get("contacts:" + index + ":emailAddress"));
                contactPersons.add(contact);
            }
        });
        this.metaData.put("contactPersons", contactPersons);
        return true;
    }

    public void convertChangeRequests(List<Map<String, Object>> changeRequests) {
        this.changeRequests = changeRequests;
    }

    @Generated
    public Organization() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public String getManageIdentifier() {
        return this.manageIdentifier;
    }

    @Generated
    public Integer getManageVersion() {
        return this.manageVersion;
    }

    @Generated
    public String getTicketKey() {
        return this.ticketKey;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public OrganizationStatus getStatus() {
        return this.status;
    }

    @Generated
    public Set<Application> getApplications() {
        return this.applications;
    }

    @Generated
    public Set<OrganizationMembership> getOrganizationMemberships() {
        return this.organizationMemberships;
    }

    @Generated
    public Set<JoinRequest> getJoinRequests() {
        return this.joinRequests;
    }

    @Generated
    public Set<Invitation> getInvitations() {
        return this.invitations;
    }

    @Generated
    public Long getMemberCount() {
        return this.memberCount;
    }

    @Generated
    public Long getApplicationCount() {
        return this.applicationCount;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSchacHomeOrganization(String schacHomeOrganization) {
        this.schacHomeOrganization = schacHomeOrganization;
    }

    @Generated
    public void setManageIdentifier(String manageIdentifier) {
        this.manageIdentifier = manageIdentifier;
    }

    @Generated
    public void setManageVersion(Integer manageVersion) {
        this.manageVersion = manageVersion;
    }

    @Generated
    public void setTicketKey(String ticketKey) {
        this.ticketKey = ticketKey;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    @Generated
    public void setStatus(OrganizationStatus status) {
        this.status = status;
    }

    @Generated
    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }

    @Generated
    public void setOrganizationMemberships(Set<OrganizationMembership> organizationMemberships) {
        this.organizationMemberships = organizationMemberships;
    }

    @Generated
    public void setJoinRequests(Set<JoinRequest> joinRequests) {
        this.joinRequests = joinRequests;
    }

    @Generated
    public void setInvitations(Set<Invitation> invitations) {
        this.invitations = invitations;
    }

    @Generated
    public void setMemberCount(Long memberCount) {
        this.memberCount = memberCount;
    }

    @Generated
    public void setApplicationCount(Long applicationCount) {
        this.applicationCount = applicationCount;
    }

    @Generated
    public void setChangeRequests(List<Map<String, Object>> changeRequests) {
        this.changeRequests = changeRequests;
    }
}

