/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.UserAccessRights;
import access.exception.UserRestrictionException;
import access.invite.InviteClient;
import access.model.User;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invite"}, produces={"application/json"})
@Transactional
public class InviteController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(InviteController.class);
    private final InviteClient inviteClient;
    private final OrganizationRepository organizationRepository;
    private final UserRepository userRepository;

    public InviteController(InviteClient inviteClient, OrganizationRepository organizationRepository, UserRepository userRepository) {
        this.inviteClient = inviteClient;
        this.organizationRepository = organizationRepository;
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/roles/{organizationGUID}/{applicationManageId}"})
    public ResponseEntity<List<Map<String, Object>>> rolesPerOrganizationInviteApplication(User user, @PathVariable String organizationGUID, @PathVariable String applicationManageId) {
        LOG.debug((Object)"/rolesPerOrganizationApplicationId");
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        if (!userFromDB.isSuperUser() && !organizationGUID.equals(userFromDB.getOrganizationGUID())) {
            throw new UserRestrictionException(String.format("User %s is not authorized for organizationGUID %s", user.getEmail(), organizationGUID));
        }
        List inviteRoles = this.inviteClient.rolesPerOrganizationApplicationId(organizationGUID, applicationManageId);
        return ResponseEntity.ok((Object)inviteRoles);
    }
}

