/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.NotFoundException;
import access.manage.ChangeRequest;
import access.manage.ConnectionProviderConverter;
import access.manage.Manage;
import access.manage.ManageAuthorization;
import access.manage.ManageData;
import access.manage.ResilientErrorHandler;
import access.model.Connection;
import access.model.EntityType;
import access.model.Environment;
import access.model.Organization;
import access.model.State;
import access.model.User;
import access.remote.RestTemplateFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final Map<Environment, RestTemplate> restTemplates;
    private final Map<String, Object> queries;
    private final ConnectionProviderConverter converter;
    private final ManageAuthorization testAuthorization;
    private final ManageAuthorization productionAuthorization;
    private final Environment activeEnvironment;

    public RemoteManage(ManageAuthorization testAuthorization, ManageAuthorization productionAuthorization, ConnectionProviderConverter converter, Environment activeEnvironment, ObjectMapper objectMapper) throws IOException {
        this.testAuthorization = testAuthorization;
        this.productionAuthorization = productionAuthorization;
        this.converter = converter;
        this.activeEnvironment = activeEnvironment;
        this.queries = (Map)objectMapper.readValue(new ClassPathResource("/manage/query_templates.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler(objectMapper);
        this.restTemplates = Map.of(Environment.TEST, RestTemplateFactory.buildRestTemplate((ResponseErrorHandler)resilientErrorHandler, (String)testAuthorization.user(), (String)testAuthorization.password()), Environment.PROD, RestTemplateFactory.buildRestTemplate((ResponseErrorHandler)resilientErrorHandler, (String)productionAuthorization.user(), (String)productionAuthorization.password()));
    }

    public List<Map<String, Object>> providers(Environment environment, EntityType ... entityTypes) {
        LOG.debug((Object)("Providers for entityTypes: " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(environment, entityType.name(), false)).flatMap(Collection::stream).toList();
    }

    public Map<String, Object> providerById(Connection connection) {
        String manageIdentifier = connection.getManageIdentifier();
        EntityType protocol = connection.getProtocol();
        Environment environment = connection.getEnvironment();
        LOG.debug((Object)("providerById: " + String.valueOf(protocol)));
        return this.providerDetails(environment, protocol, manageIdentifier);
    }

    private Map<String, Object> providerDetails(Environment environment, EntityType protocol, String manageIdentifier) {
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", url, protocol.name(), manageIdentifier);
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        ResponseEntity responseEntity = restTemplate.getForEntity(queryUrl, Map.class, new Object[0]);
        if (responseEntity.getStatusCode().equals((Object)HttpStatus.OK)) {
            return this.sanitizeProvider((Map)responseEntity.getBody());
        }
        return (Map)responseEntity.getBody();
    }

    public Map<String, Object> providerById(EntityType entityType, String manageIdentifier, Environment environment) {
        LOG.debug((Object)("providerById: " + String.valueOf(entityType)));
        return this.providerDetails(environment, entityType, manageIdentifier);
    }

    public Map<String, Object> saveIdentityProvider(Organization organization) {
        Map provider = this.providerById(EntityType.saml20_idp, organization.getManageIdentifier(), Environment.PROD);
        Map metaDataFields = ManageData.getMetaDataFields((Map)ManageData.getData((Map)provider));
        Map metaDataOrganization = organization.getMetaData();
        this.converter.convertContactPersons(metaDataOrganization, metaDataFields);
        String keyWords = String.join((CharSequence)" ", metaDataOrganization.getOrDefault("keyWords", List.of()));
        metaDataFields.put("keywords:0:nl", keyWords);
        metaDataFields.put("keywords:0:en", keyWords);
        RestTemplate restTemplate = this.environmentRestTemplate(Environment.PROD);
        String url = this.environmentUrl(Environment.PROD);
        ResponseEntity responseEntity = restTemplate.exchange(String.format("%s/manage/api/internal/metadata", url), HttpMethod.PUT, new HttpEntity((Object)provider), Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (ResilientErrorHandler.ignoreError((Map)body)) {
            return provider;
        }
        return body;
    }

    public Map<String, Object> saveProvider(Connection connection) {
        Map remoteProvider = StringUtils.hasText((String)connection.getManageIdentifier()) ? this.providerById(connection) : this.baseStructureProvider();
        Map provider = this.converter.convert(connection, remoteProvider, connection.changeRequestRequired());
        RestTemplate restTemplate = this.environmentRestTemplate(connection.getEnvironment());
        String url = this.environmentUrl(connection.getEnvironment());
        HttpMethod httpMethod = StringUtils.hasText((String)connection.getManageIdentifier()) ? HttpMethod.PUT : HttpMethod.POST;
        ResponseEntity responseEntity = restTemplate.exchange(String.format("%s/manage/api/internal/metadata", url), httpMethod, new HttpEntity((Object)provider), Map.class, new Object[0]);
        Map body = (Map)responseEntity.getBody();
        if (ResilientErrorHandler.ignoreError((Map)body)) {
            return provider;
        }
        return body;
    }

    public void deleteProvider(Connection connection) {
        Environment environment = connection.getEnvironment();
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/metadata/%s/%s", this.environmentUrl(environment), connection.getProtocol(), connection.getManageIdentifier());
        restTemplate.exchange(URI.create(url), HttpMethod.DELETE, null, Void.class);
    }

    public void rejectChangeRequest(Environment environment, ChangeRequest changeRequest) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests/reject", this.environmentUrl(environment));
        restTemplate.put(URI.create(url), (Object)changeRequest);
    }

    public List<Map<String, Object>> uniqueEntityId(Environment environment, EntityType entityType, String entityID) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = this.environmentUrl(environment);
        String queryUrl = String.format("%s/manage/api/internal/uniqueEntityId/%s", url, entityType.name());
        return (List)restTemplate.postForEntity(queryUrl, Map.of("entityid", entityID), List.class, new Object[0]).getBody();
    }

    public Map<String, Object> createChangeRequest(Environment environment, ChangeRequest changeRequest) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests", this.environmentUrl(environment));
        HttpEntity requestEntity = new HttpEntity((Object)changeRequest);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public List<Map<String, Object>> getChangeRequests(Environment environment, Connection connection) {
        RestTemplate restTemplate = this.environmentRestTemplate(environment);
        String url = String.format("%s/manage/api/internal/change-requests/%s/%s", this.environmentUrl(environment), connection.getProtocol().name(), connection.getManageIdentifier());
        return (List)restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }

    public List<Map<String, Object>> getChangeRequestsIdentityProvider(Map<String, Object> identityProvider) {
        RestTemplate restTemplate = this.environmentRestTemplate(this.activeEnvironment);
        String url = String.format("%s/manage/api/internal/change-requests/%s/%s", this.environmentUrl(this.activeEnvironment), EntityType.saml20_idp.name(), identityProvider.get("id"));
        return (List)restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }

    public String changeRequestURL(Environment environment, Connection connection) {
        String url = this.environmentUrl(environment);
        return String.format("%s/metadata/%s/%s/requests", url, connection.getProtocol().name(), connection.getManageIdentifier());
    }

    public String changeRequestURLConnectionRequest(EntityType entityType, String manageIdentifier) {
        String url = this.environmentUrl(Environment.PROD);
        return String.format("%s/metadata/%s/%s/requests", url, entityType.name(), manageIdentifier);
    }

    public Map<String, Object> identityProviderByEntityID(String entityID) {
        LOG.debug((Object)("identityProvidersByEntityID for : " + entityID));
        Map baseQuery = this.getBaseQuery(true);
        baseQuery.put("entityid", entityID);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(this.activeEnvironment), EntityType.saml20_idp.name());
        List identityProviders = (List)this.environmentRestTemplate(this.activeEnvironment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        if (identityProviders.isEmpty()) {
            throw new NotFoundException("No identityProviders found for entityID: " + entityID);
        }
        return this.sanitizeProvider((Map)identityProviders.getFirst());
    }

    public List<Map<String, Object>> serviceProvidersByEntityID(List<String> entityIdentifiers) {
        LOG.debug((Object)("serviceProvidersByEntityID for : " + String.valueOf(entityIdentifiers)));
        Map baseQuery = this.getBaseQuery(true);
        baseQuery.put("entityid", entityIdentifiers);
        return Stream.of(EntityType.oidc10_rp, EntityType.saml20_sp).flatMap(entityType -> {
            String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(this.activeEnvironment), entityType.name());
            List identityProviders = (List)this.environmentRestTemplate(this.activeEnvironment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
            return identityProviders.stream();
        }).toList();
    }

    public List<Map<String, Object>> identityProvidersByInstitutionalGUID(Environment environment, String organisationGUID) {
        LOG.debug((Object)("identityProviderByInstitutionalGUID for : " + organisationGUID));
        Map baseQuery = this.getBaseQuery(false);
        baseQuery.put("metaDataFields.coin:institution_guid", organisationGUID);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_idp.name());
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    public List<Map<String, Object>> identityProvidersLight(Environment environment) {
        LOG.debug((Object)("identityProvidersLight for environment: " + String.valueOf(environment)));
        Map baseQuery = this.getBaseQuery(false);
        ((List)baseQuery.get("REQUESTED_ATTRIBUTES")).add("metaDataFields.coin:institution_type");
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_idp.name());
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    public List<Map<String, Object>> serviceProvidersLight(Environment environment) {
        LOG.debug((Object)("serviceProvidersLight for environment: " + String.valueOf(environment)));
        Map baseQuery = this.getBaseQuery(false);
        List requestedAttributes = (List)baseQuery.get("REQUESTED_ATTRIBUTES");
        requestedAttributes.add("metaDataFields.coin:interfed_source");
        requestedAttributes.add("metaDataFields.application_tags");
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.saml20_sp.name());
        List serviceProviders = (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), EntityType.oidc10_rp.name());
        List relyingParties = (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
        serviceProviders.addAll(relyingParties);
        return serviceProviders;
    }

    public Map<String, Integer> stats() {
        LOG.debug((Object)"stats");
        String url = String.format("%s/manage/api/internal/stats", this.environmentUrl(Environment.PROD), EntityType.saml20_idp.name());
        return (Map)this.environmentRestTemplate(Environment.PROD).getForEntity(url, Map.class, new Object[0]).getBody();
    }

    public List<Map<String, Object>> identityProvidersByAllowedConnections(List<Connection> connections) {
        List<Map> body = connections.stream().filter(connection -> StringUtils.hasText((String)connection.getManageIdentifier()) && connection.getEnvironment().equals((Object)Environment.PROD) && connection.getState().equals((Object)State.prodaccepted)).map(connection -> Map.of("id", connection.getManageIdentifier(), "type", connection.getProtocol().name())).toList();
        if (body.isEmpty()) {
            return List.of();
        }
        RestTemplate restTemplate = this.environmentRestTemplate(Environment.PROD);
        String url = String.format("%s/manage/api/internal/delete-consequences", this.environmentUrl(Environment.PROD));
        return (List)restTemplate.postForEntity(URI.create(url), body, List.class).getBody();
    }

    public void connectWithoutInteraction(Map<String, Object> identityProvider, Map<String, Object> serviceProvider, User user) {
        RestTemplate restTemplate = this.environmentRestTemplate(Environment.PROD);
        String url = String.format("%s/manage/api/internal/connectWithoutInteraction", this.environmentUrl(Environment.PROD));
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("idpId", (String)ManageData.getData(identityProvider).get("entityid"));
        bodyMap.put("spId", (String)ManageData.getData(serviceProvider).get("entityid"));
        bodyMap.put("spType", (String)serviceProvider.get("type"));
        bodyMap.put("user", user.getName());
        bodyMap.put("userUrn", user.getSub());
        restTemplate.put(url, bodyMap, new Object[0]);
    }

    private List<Map<String, Object>> getRemoteMetaData(Environment environment, String type, boolean allAttributes) {
        Map baseQuery = this.getBaseQuery(allAttributes);
        String url = String.format("%s/manage/api/internal/search/%s", this.environmentUrl(environment), type);
        return (List)this.environmentRestTemplate(environment).postForObject(url, (Object)baseQuery, List.class, new Object[0]);
    }

    private Map<String, Object> getBaseQuery(boolean allAttributes) {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>((Map)this.queries.get("base_query"));
        if (allAttributes) {
            baseQuery.remove("REQUESTED_ATTRIBUTES");
            baseQuery.put("ALL_ATTRIBUTES", true);
        } else {
            baseQuery.put("REQUESTED_ATTRIBUTES", baseQuery.get("REQUESTED_ATTRIBUTES"));
        }
        return baseQuery;
    }

    private String environmentUrl(Environment environment) {
        return environment.equals((Object)Environment.TEST) ? this.testAuthorization.url() : this.productionAuthorization.url();
    }

    private RestTemplate environmentRestTemplate(Environment environment) {
        return (RestTemplate)this.restTemplates.get(environment);
    }
}

