/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.UserAccessRights;
import access.exception.InvalidInputException;
import access.exception.UserRestrictionException;
import access.invite.InviteClient;
import access.manage.Manage;
import access.manage.ManageData;
import access.model.User;
import access.repository.UserRepository;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/invite"}, produces={"application/json"})
@Transactional
public class InviteController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(InviteController.class);
    private final InviteClient inviteClient;
    private final Manage manage;
    private final UserRepository userRepository;

    public InviteController(InviteClient inviteClient, Manage manage, UserRepository userRepository) {
        this.inviteClient = inviteClient;
        this.manage = manage;
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/roles/{organizationGUID}/{applicationManageId}"})
    public ResponseEntity<List<Map<String, Object>>> rolesPerOrganizationInviteApplication(User user, @PathVariable String organizationGUID, @PathVariable String applicationManageId) {
        boolean noOrganizationGUID;
        LOG.debug((Object)"/rolesPerOrganizationApplicationId");
        User userFromDB = this.reinitializeUser(user, this.userRepository);
        if (!userFromDB.isSuperUser() && !organizationGUID.equals(userFromDB.getOrganizationGUID())) {
            throw new UserRestrictionException(String.format("User %s is not authorized for organizationGUID %s", user.getEmail(), organizationGUID));
        }
        boolean bl = noOrganizationGUID = !StringUtils.hasText((String)organizationGUID) || "undefined".equals(organizationGUID) || "null".equalsIgnoreCase(organizationGUID);
        if (noOrganizationGUID && userFromDB.isSuperUser()) {
            Map identityProvider = this.manage.identityProviderByEntityID(userFromDB.getAuthenticatingAuthority());
            String idpInstitutionGUID = (String)ManageData.getMetaDataFields((Map)ManageData.getData((Map)identityProvider)).get("coin:institution_guid");
            if (StringUtils.hasText((String)idpInstitutionGUID)) {
                organizationGUID = idpInstitutionGUID;
            } else {
                LOG.warn((Object)("Not fetching invite roles as there is no institution GUID for IdP: " + user.getAuthenticatingAuthority()));
                return ResponseEntity.ok(List.of());
            }
        }
        if (!applicationManageId.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$") && !applicationManageId.matches("^\\d+$")) {
            throw new InvalidInputException(String.format("ApplicationManageId %s is not a valid UUID or number", applicationManageId));
        }
        List inviteRoles = this.inviteClient.rolesPerOrganizationApplicationId(organizationGUID, applicationManageId);
        return ResponseEntity.ok((Object)inviteRoles);
    }
}

