/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.exception.NotAllowedException;
import access.security.LocalDevelopmentAuthenticationFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/test"}, produces={"application/json"})
public class LoginController {
    private final Environment environment;
    private final SecurityContextRepository securityContextRepository;

    public LoginController(Environment environment, SecurityContextRepository securityContextRepository) {
        this.environment = environment;
        this.securityContextRepository = securityContextRepository;
    }

    @PutMapping(value={"/login"})
    public ResponseEntity<Void> login(@RequestBody Map<String, Object> body, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        if (!this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"test"}))) {
            throw new NotAllowedException("Not allowed");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            LocalDevelopmentAuthenticationFilter.populateSecurityContext(body);
        }
        this.securityContextRepository.saveContext(SecurityContextHolder.getContext(), servletRequest, servletResponse);
        return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)201)).build();
    }
}

