/*
 * Decompiled with CFR 0.152.
 */
package access.stats;

import access.manage.Manage;
import access.manage.ManageData;
import access.stats.Statistics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(prefix="statistics", name={"enabled"}, havingValue="false")
public class StatisticsMock
implements Statistics {
    private final Manage manage;

    public StatisticsMock(Manage manage) {
        this.manage = manage;
    }

    public List<Object> loginTimeFrame(long from, long to, String scale, String idpEntityId, String spEntityId) {
        long step = this.step(scale);
        ArrayList<Object> result = new ArrayList<Object>();
        for (long i = from; i <= to; i += step) {
            HashMap<String, Object> point = new HashMap<String, Object>();
            point.put("count_user_id", this.countValue());
            if (!"minute".equals(scale) && !"hour".equals(scale)) {
                point.put("distinct_count_user_id", this.countValue());
            }
            if (StringUtils.hasText((String)spEntityId)) {
                point.put("sp_entity_id", spEntityId);
            }
            point.put("idp_entity_id", idpEntityId);
            point.put("time", i * 1000L);
            result.add(point);
        }
        return result;
    }

    public List<Object> loginAggregated(String period, String idpEntityId, String spEntityId) {
        Calendar today = Calendar.getInstance();
        today.set(1, Integer.parseInt(period.substring(0, 4)));
        today.set(11, 0);
        today.set(12, 0);
        today.set(5, 1);
        if (period.length() > 4) {
            switch (period.substring(4, 5).toUpperCase()) {
                case "Q": {
                    today.set(2, (Integer.parseInt(period.substring(5)) - 1) * 3);
                    break;
                }
                case "M": {
                    today.set(2, Integer.parseInt(period.substring(5)) - 1);
                    break;
                }
                case "W": {
                    today.set(3, Integer.parseInt(period.substring(5)));
                    break;
                }
                case "D": {
                    today.set(6, Integer.parseInt(period.substring(5)));
                }
            }
        } else {
            today.set(2, 0);
        }
        long date = today.getTimeInMillis() / 1000L;
        Map identityProvider = this.manage.identityProviderByEntityID(idpEntityId);
        Map data = ManageData.getData((Map)identityProvider);
        List<String> entityIdentifiers = data.getOrDefault("allowedEntities", List.of()).stream().map(sp -> (String)sp.get("name")).toList();
        List serviceProvider = this.manage.serviceProvidersByEntityID(entityIdentifiers);
        return serviceProvider.stream().filter(sp -> !StringUtils.hasText((String)spEntityId) || spEntityId.equals(ManageData.getData((Map)sp).get("entityid"))).map(sp -> {
            HashMap<String, Object> point = new HashMap<String, Object>();
            point.put("count_user_id", this.countValue());
            point.put("distinct_count_user_id", this.countValue() / 2L);
            point.put("sp_entity_id", ManageData.getData((Map)sp).get("entityid"));
            point.put("idp_entity_id", idpEntityId);
            point.put("time", date);
            return point;
        }).collect(Collectors.toList());
    }

    public List<Object> uniqueLoginCount(long from, long to, String idpEntityId, String spEntityId) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, Object> point = new HashMap<String, Object>();
        point.put("count_user_id", this.countValue());
        point.put("sp_entity_id", spEntityId);
        point.put("idp_entity_id", idpEntityId);
        point.put("time", from);
        result.add(point);
        return result;
    }

    private long countValue() {
        double base = Math.floor(10000.0 * (Math.random() + 1.0));
        return (long)base;
    }

    private long step(String scale) {
        return switch (scale) {
            case "minute" -> 60L;
            case "hour" -> 3600L;
            case "day" -> 86400L;
            case "week" -> 604800L;
            case "month" -> 2592000L;
            case "quarter" -> 7776000L;
            case "year" -> 31536000L;
            default -> throw new IllegalArgumentException("Unknown scale:" + scale);
        };
    }
}

