/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.InvalidInputException;
import access.exception.NotFoundException;
import access.jira.JiraClient;
import access.jira.JiraIssue;
import access.manage.ChangeRequest;
import access.manage.ConnectionProviderConverter;
import access.manage.Manage;
import access.manage.ManageData;
import access.manage.PathUpdateType;
import access.manage.RequestType;
import access.model.Application;
import access.model.Connection;
import access.model.ConnectionStatus;
import access.model.EntityType;
import access.model.Environment;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.ConnectionRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.PasswordGenerator;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/connections"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class ConnectionController
implements UserAccessRights {
    public static final int SECRET_LENGTH = 36;
    private static final Log LOG = LogFactory.getLog(ConnectionController.class);
    private final ConnectionRepository connectionRepository;
    private final ApplicationRepository applicationRepository;
    private final UserRepository userRepository;
    private final Manage manage;
    private final JiraClient jiraClient;
    private final PasswordGenerator passwordGenerator = new PasswordGenerator();
    private final List<CharacterRule> rules = this.initPasswordGeneratorRules();
    private final ConnectionProviderConverter connectionProviderConverter;

    public ConnectionController(ConnectionRepository connectionRepository, ApplicationRepository applicationRepository, UserRepository userRepository, Manage manage, JiraClient jiraClient, ConnectionProviderConverter connectionProviderConverter) {
        this.connectionRepository = connectionRepository;
        this.applicationRepository = applicationRepository;
        this.userRepository = userRepository;
        this.manage = manage;
        this.jiraClient = jiraClient;
        this.connectionProviderConverter = connectionProviderConverter;
    }

    private List<CharacterRule> initPasswordGeneratorRules() {
        return List.of(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 8), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 8), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 8));
    }

    @GetMapping(value={"/{connectionId}"})
    public ResponseEntity<Connection> find(User user, @PathVariable(value="connectionId") Long connectionId) {
        LOG.debug((Object)("/find connection for " + user.getEmail()));
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        if (StringUtils.hasText((String)connection.getManageIdentifier())) {
            Map provider = this.manage.providerById(connection);
            if (connection.mergeMetaData(provider, false)) {
                this.connectionRepository.save((Object)connection);
            }
            if (connection.getStatus().equals((Object)ConnectionStatus.PROD_READY)) {
                connection.convertChangeRequests(this.manage.getChangeRequests(Environment.PROD, connection));
            }
        }
        return ResponseEntity.ok((Object)connection);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<Connection> create(User user, @Validated @RequestBody Connection connection) {
        LOG.debug((Object)("/create connection by " + user.getEmail()));
        if (!connection.isValid()) {
            throw new InvalidInputException("Connection is not valid");
        }
        Long applicationID = connection.getApplication().getId();
        Application application = (Application)this.applicationRepository.findById((Object)applicationID).orElseThrow(() -> new NotFoundException("Application not found"));
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationWriteAccess(user, application);
        connection.setCreatedAt(Instant.now());
        connection.setApplication(application);
        connection = this.saveConnection(connection);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)connection);
    }

    @PutMapping(value={"", "/"})
    public ResponseEntity<Connection> update(User user, @Validated @RequestBody Connection connectionData) {
        LOG.debug((Object)("/update connection by " + user.getEmail()));
        if (!connectionData.isValid()) {
            throw new InvalidInputException("Connection is not valid");
        }
        Connection connection = this.findConnectionForAuthorizedUser(user, connectionData.getId());
        connection.merge(connectionData);
        if (connection.changeRequestRequired()) {
            connection = this.productionReadyChangeRequests(connection, user);
            connection.convertChangeRequests(this.manage.getChangeRequests(Environment.PROD, connection));
        } else {
            connection = this.saveConnection(connection);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)connection);
    }

    @GetMapping(value={"/change-requests/{connectionId}"}, produces={"application/json"})
    public ResponseEntity<List<Map<String, Object>>> changeRequests(User user, @PathVariable(value="connectionId") Long connectionId) {
        Connection connection = this.findConnectionForAuthorizedUser(user, connectionId);
        List changeRequests = this.manage.getChangeRequests(connection.getEnvironment(), connection);
        return ResponseEntity.ok((Object)changeRequests);
    }

    @PutMapping(value={"/reset-secret/{connectionId}"}, produces={"application/json"})
    public Map<String, String> secret(User user, @PathVariable(value="connectionId") Long connectionId) {
        Connection connection = this.findConnectionForAuthorizedUser(user, connectionId);
        String secret = this.passwordGenerator.generatePassword(36, this.rules);
        connection.getMetaData().put("secret", secret);
        connection.setSecretSet(false);
        this.saveConnection(connection);
        return Collections.singletonMap("secret", secret);
    }

    @PutMapping(value={"/request-production-status/{connectionId}"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> requestProductionStatus(User user, @PathVariable(value="connectionId") Long connectionId) {
        Connection connection = this.findConnectionForAuthorizedUser(user, connectionId);
        String changeRequestURL = this.manage.changeRequestURL(connection.getEnvironment(), connection);
        Map provider = this.manage.providerById(connection);
        String entityId = (String)((Map)provider.get("data")).get("entityid");
        String lineSeparator = System.lineSeparator();
        String summary = String.format("Production status requested by %s for %s.", user.getName(), connection.getName());
        String jiraKey = this.jiraClient.create(new JiraIssue(entityId, null, String.format("%s A change request in manage has been created to merge this user request. See:%s%s", summary, lineSeparator, changeRequestURL), summary, connection.getProtocol(), user.getEmail()));
        ChangeRequest changeRequest = new ChangeRequest(connection.getManageIdentifier(), connection.getProtocol(), Map.of("state", "prodaccepted"), Map.of("user", user.getEmail(), "notes", String.format("Production status requested by %s for %s. See Jira %s", user.getName(), connection.getName(), jiraKey)), false, PathUpdateType.ADDITION, RequestType.ProductionStatusRequest);
        Map changeRequestResponse = this.manage.createChangeRequest(connection.getEnvironment(), changeRequest);
        LOG.debug((Object)("Change request response from manage: " + String.valueOf(changeRequestResponse)));
        connection.setStatus(ConnectionStatus.PENDING_PROD);
        this.saveConnection(connection);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("status", HttpStatus.CREATED.value(), "jiraKey", jiraKey));
    }

    @DeleteMapping(value={"", "/{connectionId}"})
    public ResponseEntity<Map<String, Object>> delete(User user, @PathVariable(value="connectionId") Long connectionId) {
        LOG.debug((Object)("/delete connection by " + user.getEmail()));
        Connection connection = this.findConnectionForAuthorizedUser(user, connectionId);
        if (StringUtils.hasText((String)connection.getManageIdentifier())) {
            this.manage.deleteProvider(connection);
        }
        Application application = connection.getApplication();
        application.removeConnection(connection);
        if (StringUtils.hasText((String)connection.getManageIdentifier())) {
            this.manage.deleteProvider(connection);
        }
        this.connectionRepository.deleteConnectionById(connectionId);
        return Results.deleteResult();
    }

    @GetMapping(value={"/identity-providers-allowed-connections/{connectionId}"})
    public ResponseEntity<List<Map<String, Object>>> identityProvidersByAllowedConnections(User user, @PathVariable(value="connectionId") Long connectionId) {
        LOG.debug((Object)("/identityProvidersByAllowedConnections by: " + user.getEmail()));
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        List identityProviders = this.manage.identityProvidersByAllowedConnections(List.of(connection));
        return ResponseEntity.ok((Object)identityProviders);
    }

    private Connection productionReadyChangeRequests(Connection connection, User user) {
        Environment environment = connection.getEnvironment();
        String changeRequestURL = this.manage.changeRequestURL(environment, connection);
        Map provider = this.manage.providerById(connection);
        connection.updateRemoteManageData(provider);
        String entityId = (String)((Map)provider.get("data")).get("entityid");
        String summary = String.format("Data change requested by %s for %s with entityID %s", user.getName(), connection.getName(), entityId);
        String jiraKey = this.jiraClient.create(new JiraIssue(entityId, null, String.format("%s A change request in manage has been created to merge this user request. See:%s%s", summary, System.lineSeparator(), changeRequestURL), summary, connection.getProtocol(), user.getEmail()));
        Map<String, String> auditData = Map.of("user", user.getEmail(), "notes", String.format("Production status requested by %s for %s. See Jira %s", user.getName(), connection.getName(), jiraKey));
        List changeRequests = this.connectionProviderConverter.deduceChangeRequests(connection, provider, auditData);
        changeRequests.forEach(changeRequest -> this.manage.createChangeRequest(environment, changeRequest));
        connection.mergeMetaData(provider, true);
        connection = (Connection)this.connectionRepository.save((Object)connection);
        connection.convertChangeRequests(this.manage.getChangeRequests(Environment.PROD, connection));
        return connection;
    }

    private Connection saveConnection(Connection connection) {
        if (!connection.getStatus().equals((Object)ConnectionStatus.OPEN)) {
            List contactPersons;
            Map data;
            Map metaDataFields;
            String secretFromManage;
            boolean secretNotSet;
            boolean isPrivateRelyingParty = connection.getProtocol().equals((Object)EntityType.oidc10_rp) && connection.getMetaData().getOrDefault("pkce", false) == Boolean.FALSE;
            boolean bl = secretNotSet = !connection.isSecretSet();
            if (isPrivateRelyingParty && secretNotSet) {
                String secret = connection.getMetaData().getOrDefault("secret", this.passwordGenerator.generatePassword(36, this.rules));
                connection.getMetaData().put("secret", secret);
                connection.setSecretSet(true);
            }
            Map provider = this.manage.saveProvider(connection);
            connection.updateRemoteManageData(provider);
            if (isPrivateRelyingParty && secretNotSet && StringUtils.hasText((String)(secretFromManage = (String)(metaDataFields = ManageData.getMetaDataFields((Map)(data = ManageData.getData((Map)provider)))).get("secret"))) && secretFromManage.length() != 36) {
                String originalSecret = (String)connection.getMetaData().get("secret");
                connection.getMetaData().put("secret", secretFromManage);
                if (originalSecret.length() == 36) {
                    connection.getMetaData().put("originalSecret", originalSecret);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(contactPersons = (List)connection.getMetaData().get("contactPersons")))) {
                Application application = connection.getApplication();
                application.getMetaData().put("contactPersons", contactPersons);
                this.applicationRepository.save((Object)application);
                connection.getMetaData().remove("contactPersons");
            }
        }
        return (Connection)this.connectionRepository.save((Object)connection);
    }

    private Connection findConnectionForAuthorizedUser(User user, Long connectionId) {
        Connection connection = (Connection)this.connectionRepository.findById((Object)connectionId).orElseThrow(() -> new NotFoundException("Connection not found"));
        Application application = connection.getApplication();
        user = this.reinitializeUser(user, this.userRepository);
        this.confirmApplicationWriteAccess(user, application);
        return connection;
    }
}

