/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.FullSearchQueryParser;
import access.api.Results;
import access.api.UserAccessRights;
import access.config.Config;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.mail.MailBox;
import access.manage.Manage;
import access.model.Authority;
import access.model.Institution;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.OrganizationStatus;
import access.model.User;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@RestController
@RequestMapping(value={"/api/v1/users"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class UserController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final Config config;
    private final UserRepository userRepository;
    private final OrganizationRepository organizationRepository;
    private final Manage manage;
    private final MailBox mailBox;

    @Autowired
    public UserController(Config config, UserRepository userRepository, OrganizationRepository organizationRepository, Manage manage, MailBox mailBox) {
        this.config = config;
        this.userRepository = userRepository;
        this.organizationRepository = organizationRepository;
        this.manage = manage;
        this.mailBox = mailBox;
    }

    @GetMapping(value={"/config"})
    public ResponseEntity<Config> config(User user) {
        LOG.debug((Object)"/config");
        Config result = new Config(this.config);
        result.withAuthenticated(user != null && user.getId() != null).withName(user != null ? user.getName() : null).withStats(this.manage.stats());
        if (user != null) {
            this.verifyMissingAttributes(user, result);
        }
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/login"})
    public View login() {
        LOG.debug((Object)"/login");
        return new RedirectView(this.config.getClientUrl(), false);
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<User> me(@Parameter(hidden=true) User user, Authentication authentication) {
        LOG.debug((Object)String.format("/me for user %s", user.getEduPersonPrincipalName()));
        User userFromDB = (User)this.userRepository.findDetailsById(user.getId()).orElseThrow(() -> new NotFoundException("User not found"));
        String schacHomeOrganization = userFromDB.getSchacHomeOrganization();
        boolean isExternalUserFromSchacHome = schacHomeOrganization.equals(this.config.getEduIdSchacHomeOrganization());
        userFromDB.setExternalUser(isExternalUserFromSchacHome);
        if (!isExternalUserFromSchacHome) {
            OidcUser oidcUser = (OidcUser)authentication.getPrincipal();
            Map claims = oidcUser.getUserInfo().getClaims();
            String authenticatingAuthority = (String)claims.get("authenticating_authority");
            Map identityProvider = this.manage.identityProviderByEntityID(authenticatingAuthority);
            String manageIdentifier = (String)identityProvider.get("_id");
            userFromDB.setIdentityProvider(identityProvider);
            String obtainedAcr = claims.getOrDefault("acr", "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
            userFromDB.setLoaLevel(this.convertLoaLevel(obtainedAcr));
            List changeRequests = this.manage.getChangeRequestsIdentityProvider(identityProvider);
            userFromDB.setChangeRequests(changeRequests);
            if (userFromDB.getOrganizationMemberships().stream().noneMatch(organizationMembership -> organizationMembership.getOrganization().getManageIdentifier().equals(manageIdentifier))) {
                Optional organizationOptional = this.organizationRepository.findByManageIdentifier(manageIdentifier);
                Institution institution = claims.getOrDefault("INSTITUTION", null);
                userFromDB.setInstitution(institution);
                Authority authority = userFromDB.isInstitutionAdmin() && institution != null ? Authority.ADMIN : Authority.MEMBER;
                organizationOptional.ifPresentOrElse(organization -> userFromDB.addOrganizationMembership(new OrganizationMembership(userFromDB, organization, authority)), () -> {
                    Institution institutionForOrg = Objects.isNull(institution) ? new Institution(identityProvider) : institution;
                    String organizationName = String.format("%s (%s)", institutionForOrg.getName(), institutionForOrg.getOrganizationName());
                    Integer manageVersion = (Integer)identityProvider.get("version");
                    Organization organization = new Organization(organizationName, schacHomeOrganization, manageIdentifier, manageVersion);
                    organization.setStatus(OrganizationStatus.APPROVED);
                    this.organizationRepository.save((Object)organization);
                    userFromDB.addOrganizationMembership(new OrganizationMembership(userFromDB, organization, authority));
                });
            }
        }
        this.userRepository.save((Object)userFromDB);
        return ResponseEntity.ok((Object)userFromDB);
    }

    @GetMapping(value={"/other/{id}"})
    public ResponseEntity<User> details(@PathVariable(value="id") Long id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/other/%s for user %s", id, user.getEduPersonPrincipalName()));
        if (!user.isSuperUser()) {
            throw new NotAllowedException("Not allowed endpoint by " + user.getEmail());
        }
        User other = (User)this.userRepository.findById((Object)id).orElseThrow(() -> new NotFoundException("User not found"));
        return ResponseEntity.ok((Object)other);
    }

    @DeleteMapping
    public ResponseEntity<Map<String, Object>> deleteMe(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("/delete for user %s", user.getEduPersonPrincipalName()));
        User userFromDB = (User)this.userRepository.findDetailsById(user.getId()).orElseThrow(() -> new NotFoundException("User not found"));
        this.userRepository.delete((Object)userFromDB);
        return Results.deleteResult();
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<Map<String, Object>> logout(HttpServletRequest request) {
        LOG.debug((Object)"/logout");
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return Results.okResult();
    }

    @PostMapping(value={"/feedback"})
    public ResponseEntity<Map<String, Object>> feedback(User user, @RequestBody Map<String, String> body) {
        LOG.debug((Object)("/feedback from " + user.getEmail()));
        String message = body.get("message");
        if (StringUtils.hasText((String)message)) {
            this.mailBox.sendFeedbackMail(user, message);
        }
        return Results.okResult();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<Map<String, Object>>> search(@Parameter(hidden=true) User user, @RequestParam(value="query", required=false, defaultValue="") String query, @RequestParam(value="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="sort", required=false, defaultValue="name") String sort, @RequestParam(value="sortDirection", required=false, defaultValue="ASC") String sortDirection) {
        LOG.debug((Object)String.format("/search for user %s", user.getEduPersonPrincipalName()));
        this.confirmSuperUser(user);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortDirection), (String[])new String[]{sort}));
        Page usersPage = StringUtils.hasText((String)query) ? this.userRepository.searchByPageWithKeyword(FullSearchQueryParser.parse((String)query), (Pageable)pageable) : this.userRepository.searchByPage((Pageable)pageable);
        return ResponseEntity.ok((Object)usersPage);
    }

    private void verifyMissingAttributes(User user, Config result) {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (!StringUtils.hasText((String)user.getEmail())) {
            missingAttributes.add("email");
        }
        if (!StringUtils.hasText((String)user.getSchacHomeOrganization())) {
            missingAttributes.add("schacHomeOrganization");
        }
        if (!StringUtils.hasText((String)user.getFamilyName())) {
            missingAttributes.add("familyName");
        }
        if (!StringUtils.hasText((String)user.getGivenName())) {
            missingAttributes.add("givenName");
        }
        if (!missingAttributes.isEmpty()) {
            result.withMissingAttributes(missingAttributes);
        }
    }

    private int convertLoaLevel(String acr) {
        if (!StringUtils.hasText((String)acr) || acr.trim().toLowerCase().endsWith("password")) {
            return 1;
        }
        try {
            int loa = Integer.parseInt(acr.substring(acr.length() - 1));
            return loa == 5 ? 1 : loa;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }
}

