/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.exception.UserRestrictionException;
import access.manage.Manage;
import access.manage.ManageData;
import access.manage.PolicyDefinition;
import access.model.User;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public interface PolicyAccessRights {
    default public void confirmPolicyAccess(User user, PolicyDefinition policyDefinition, Manage manage) {
        if (user.isSuperUser()) {
            return;
        }
        List<String> authenticatingAuthority = List.of(user.getAuthenticatingAuthority());
        if (!policyDefinition.getIdentityProviderIds().stream().map(policyProvider -> policyProvider.getName()).toList().equals(authenticatingAuthority)) {
            this.throwUserRestrictionException(user, policyDefinition);
        }
        List<String> serviceProviderIdentifiers = policyDefinition.getServiceProviderIds().stream().map(policyProvider -> policyProvider.getName()).toList();
        Map identityProvider = manage.identityProviderByEntityID(user.getAuthenticatingAuthority());
        Map data = ManageData.getData((Map)identityProvider);
        List<String> allowedEntities = data.getOrDefault("allowedEntities", List.of()).stream().map(allowedEntry -> (String)allowedEntry.get("name")).toList();
        if (!new HashSet<String>(allowedEntities).containsAll(serviceProviderIdentifiers)) {
            this.throwUserRestrictionException(user, policyDefinition);
        }
    }

    default public void throwUserRestrictionException(User user, PolicyDefinition policyDefinition) {
        throw new UserRestrictionException(String.format("User %s from %s is not allowed access to policy %s", user.getEmail(), user.getAuthenticatingAuthority(), policyDefinition.getIdentityProviderIds()));
    }
}

