/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.DuplicateJoinRequestException;
import access.exception.NotFoundException;
import access.mail.MailBox;
import access.model.Authority;
import access.model.JoinRequest;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.JoinRequestRepository;
import access.repository.OrganizationMembershipRepository;
import access.repository.OrganizationRepository;
import access.request.JoinRequestApproval;
import access.request.JoinRequestForm;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/join"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class JoinRequestController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(JoinRequestController.class);
    private final JoinRequestRepository joinRequestRepository;
    private final OrganizationRepository organizationRepository;
    private final OrganizationMembershipRepository organizationMembershipRepository;
    private final MailBox mailBox;

    public JoinRequestController(JoinRequestRepository joinRequestRepository, OrganizationRepository organizationRepository, OrganizationMembershipRepository organizationMembershipRepository, MailBox mailBox) {
        this.joinRequestRepository = joinRequestRepository;
        this.organizationRepository = organizationRepository;
        this.organizationMembershipRepository = organizationMembershipRepository;
        this.mailBox = mailBox;
    }

    @GetMapping(value={"/all/{organizationId}"})
    public ResponseEntity<List<JoinRequest>> allByOrganization(@PathVariable(value="organizationId") Long organizationId, User user) {
        LOG.debug((Object)"/all");
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).orElseThrow(() -> new NotFoundException("Organisation not found"));
        this.confirmOrganizationMembership(user, organization, Authority.MEMBER);
        List joinRequests = this.joinRequestRepository.findByOrganization(organization);
        return ResponseEntity.ok((Object)joinRequests);
    }

    @PostMapping(value={"", "/"})
    public ResponseEntity<JoinRequest> create(User user, @RequestBody JoinRequestForm joinRequestForm) {
        LOG.debug((Object)("/create joinRequest by " + user.getEmail()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)joinRequestForm.getOrganizationId()).orElseThrow(() -> new NotFoundException("Organization not found"));
        List joinRequests = this.joinRequestRepository.findByOrganization(organization);
        if (joinRequests.stream().anyMatch(jr -> jr.getUser().getId().equals(user.getId()))) {
            throw new DuplicateJoinRequestException(String.format("Duplicate join request for user %s and organization %s", user.getEmail(), organization.getName()));
        }
        JoinRequest joinRequest = new JoinRequest(user, organization, joinRequestForm.getMessage(), joinRequestForm.getLanguage());
        joinRequest = (JoinRequest)this.joinRequestRepository.save((Object)joinRequest);
        this.mailBox.sendJoinRequestMail(joinRequest);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)joinRequest);
    }

    @PutMapping(value={"/approval"})
    public ResponseEntity<Map<String, Object>> approval(User user, @RequestBody JoinRequestApproval joinRequestApproval) {
        LOG.debug((Object)("/approval joinRequest by " + user.getEmail()));
        Long joinRequestId = joinRequestApproval.getJoinRequestId();
        JoinRequest joinRequest = (JoinRequest)this.joinRequestRepository.findById((Object)joinRequestId).orElseThrow(() -> new NotFoundException("JoinRequest not found"));
        Organization organization = joinRequest.getOrganization();
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        if (joinRequestApproval.isApproved()) {
            OrganizationMembership organizationMembership = new OrganizationMembership(joinRequest.getUser(), organization, Authority.MEMBER);
            this.organizationMembershipRepository.save((Object)organizationMembership);
            this.mailBox.sendJoinRequestAcceptedMail(joinRequest);
        } else {
            this.mailBox.sendJoinRequestDeniedMail(joinRequest);
        }
        organization.removeJoinRequest(joinRequest);
        this.joinRequestRepository.deleteJoinRequestById(joinRequestId);
        return Results.createResult();
    }
}

