/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.manage.Manage;
import access.manage.ManageData;
import access.model.EntityType;
import access.model.Environment;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/public"}, produces={"application/json"})
public class PublicController {
    private static final Log LOG = LogFactory.getLog(PublicController.class);
    private final Manage manage;

    public PublicController(Manage manage) {
        this.manage = manage;
    }

    @GetMapping(value={"/service-providers"})
    public ResponseEntity<List<Map<String, Object>>> serviceProviders() {
        LOG.debug((Object)"/serviceProviders");
        return ResponseEntity.ok((Object)this.manage.serviceProvidersLight(Environment.PROD));
    }

    @GetMapping(value={"/identity-providers"})
    public ResponseEntity<List<Map<String, Object>>> identityProviders() {
        LOG.debug((Object)"/identityProviders");
        return ResponseEntity.ok((Object)this.manage.identityProvidersLight(Environment.PROD));
    }

    @GetMapping(value={"/service-provider-detail/{type}/{identifier}"})
    public ResponseEntity<Map<String, Object>> serviceProviderDetail(@PathVariable(value="type") EntityType entityType, @PathVariable(value="identifier") String identifier) {
        LOG.debug((Object)"/identityProviders");
        Map provider = this.manage.providerById(entityType, identifier, Environment.PROD);
        ManageData.getMetaDataFields((Map)ManageData.getData((Map)provider)).keySet().removeIf(key -> key.startsWith("contacts:"));
        return ResponseEntity.ok((Object)provider);
    }
}

