/*
 * Decompiled with CFR 0.152.
 */
package access.invite;

import access.remote.RestTemplateFactory;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class InviteClient {
    private final boolean enabled;
    private final String url;
    private final RestTemplate restTemplate;

    public InviteClient(@Value(value="${invite.enabled}") boolean enabled, @Value(value="${invite.url}") String url, @Value(value="${invite.user}") String user, @Value(value="${invite.password}") String password) {
        this.enabled = enabled;
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        this.restTemplate = RestTemplateFactory.buildRestTemplate((String)user, (String)password);
    }

    public List<Map<String, Object>> rolesPerOrganizationApplicationId(String organizationGUID, String applicationManageId) {
        if (!this.enabled) {
            return List.of();
        }
        return (List)this.restTemplate.getForObject(this.url + "/api/external/v1/internal/invite/roles/{organizationGUID}/{applicationManageId}", List.class, new Object[]{organizationGUID, applicationManageId});
    }
}

