/*
 * Decompiled with CFR 0.152.
 */
package access.manage;

import access.manage.Contact;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class MetaData
implements Serializable {
    private final String entityID;
    private final String name;
    private final List<String> acsLocations;
    private final List<Contact> contactPersons;
    private final String description;

    public MetaData(EntityDescriptor entityDescriptor) {
        this.entityID = entityDescriptor.getEntityID();
        List roleDescriptors = entityDescriptor.getRoleDescriptors();
        SPSSODescriptor roleDescriptor = (SPSSODescriptor)roleDescriptors.getFirst();
        this.acsLocations = roleDescriptor.getAssertionConsumerServices().stream().map(assertionConsumerService -> assertionConsumerService.getLocation()).toList();
        this.contactPersons = entityDescriptor.getContactPersons().stream().map(Contact::new).toList();
        Optional<String> names = roleDescriptor.getAttributeConsumingServices().stream().map(attributeConsumingService -> attributeConsumingService.getNames()).flatMap(x -> x.stream()).map(serviceName -> serviceName.getValue()).findFirst();
        this.name = names.orElse(null);
        Optional<String> descriptions = roleDescriptor.getAttributeConsumingServices().stream().map(attributeConsumingService -> attributeConsumingService.getDescriptions()).flatMap(x -> x.stream()).map(serviceDescription -> serviceDescription.getValue()).findFirst();
        this.description = descriptions.orElse(null);
    }

    @Generated
    public String getEntityID() {
        return this.entityID;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getAcsLocations() {
        return this.acsLocations;
    }

    @Generated
    public List<Contact> getContactPersons() {
        return this.contactPersons;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MetaData(String entityID, String name, List<String> acsLocations, List<Contact> contactPersons, String description) {
        this.entityID = entityID;
        this.name = name;
        this.acsLocations = acsLocations;
        this.contactPersons = contactPersons;
        this.description = description;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData other = (MetaData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$entityID = this.getEntityID();
        String other$entityID = other.getEntityID();
        if (this$entityID == null ? other$entityID != null : !this$entityID.equals(other$entityID)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$acsLocations = this.getAcsLocations();
        List other$acsLocations = other.getAcsLocations();
        if (this$acsLocations == null ? other$acsLocations != null : !((Object)this$acsLocations).equals(other$acsLocations)) {
            return false;
        }
        List this$contactPersons = this.getContactPersons();
        List other$contactPersons = other.getContactPersons();
        if (this$contactPersons == null ? other$contactPersons != null : !((Object)this$contactPersons).equals(other$contactPersons)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetaData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entityID = this.getEntityID();
        result = result * 59 + ($entityID == null ? 43 : $entityID.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $acsLocations = this.getAcsLocations();
        result = result * 59 + ($acsLocations == null ? 43 : ((Object)$acsLocations).hashCode());
        List $contactPersons = this.getContactPersons();
        result = result * 59 + ($contactPersons == null ? 43 : ((Object)$contactPersons).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

