/*
 * Decompiled with CFR 0.152.
 */
package access.stats;

import access.remote.RestTemplateFactory;
import access.stats.Statistics;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnProperty(prefix="statistics", name={"enabled"}, havingValue="true")
public class StatisticsRemote
implements Statistics {
    private final RestTemplate restTemplate;
    private final String baseUrl;

    @Autowired
    public StatisticsRemote(@Value(value="${statistics.user}") String user, @Value(value="${statistics.password}") String password, @Value(value="${statistics.url}") String baseUrl) {
        this.restTemplate = RestTemplateFactory.buildRestTemplate((String)user, (String)password);
        this.baseUrl = baseUrl;
    }

    public List<Object> loginTimeFrame(long from, long to, String scale, String idpEntityId, String spEntityId) {
        String idp = this.encodeEntityID(idpEntityId);
        StringBuilder url = new StringBuilder(String.format("%s/public/login_time_frame?from=%s&to=%s&include_unique=true&scale=%s&epoch=ms&idp_id=%s", this.baseUrl, from, to, scale, idp));
        if (StringUtils.hasText((String)spEntityId)) {
            url.append(String.format("&sp_id=%s", this.encodeEntityID(spEntityId)));
        }
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    private String encodeEntityID(String entityID) {
        return URLEncoder.encode(entityID, Charset.defaultCharset());
    }

    public List<Object> loginAggregated(String period, String idpEntityId, String spEntityId) {
        StringBuilder url = new StringBuilder(String.format("%s/public/login_aggregated?period=%s&include_unique=true&idp_id=%s&group_by=sp_id", this.baseUrl, period, this.encodeEntityID(idpEntityId)));
        if (StringUtils.hasText((String)spEntityId)) {
            url.append(String.format("&sp_id=%s", this.encodeEntityID(spEntityId)));
        }
        return (List)this.restTemplate.getForEntity(url.toString(), List.class, new Object[0]).getBody();
    }

    public List<Object> uniqueLoginCount(long from, long to, String idpEntityId, String spEntityId) {
        String url = String.format("%s/public/unique_login_count?from=%s&to=%s&include_unique=true&epoch=ms&idp_id=%s&sp_id=%s", this.baseUrl, from, to, this.encodeEntityID(idpEntityId), this.encodeEntityID(spEntityId));
        return (List)this.restTemplate.getForEntity(url, List.class, new Object[0]).getBody();
    }
}

