/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.exception.InvalidInputException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class FullSearchQueryParser {
    private static final Set<String> stopWords = Set.of("a", "about", "an", "are", "as", "at", "be", "by", "com", "de", "en", "for", "from", "how", "i", "in", "is", "it", "la", "of", "on", "or", "that", "the", "this", "to", "was", "what", "when", "where", "who", "will", "with", "und", "www");

    private FullSearchQueryParser() {
    }

    public static String parse(String query) {
        if (!StringUtils.hasText((String)query)) {
            throw new InvalidInputException("Full text query parameter has @NotNull @NotBlank requirement");
        }
        String safeQuery = query.replaceAll("[<>()~\"]", " ");
        String parsedQuery = Stream.of(safeQuery.split("[ @.,+*-]")).filter(part -> part.length() >= 3 && !stopWords.contains(part.toLowerCase())).map(part -> "+" + part).collect(Collectors.joining(" "));
        if (parsedQuery.isEmpty()) {
            throw new InvalidInputException("Search query contains no usable terms after filtering");
        }
        return parsedQuery + "*";
    }
}

