/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.api.Results;
import access.api.UserAccessRights;
import access.exception.NotAllowedException;
import access.exception.NotFoundException;
import access.jira.JiraClient;
import access.jira.JiraIssue;
import access.mail.MailBox;
import access.manage.ChangeRequest;
import access.manage.DashBoardConnectionOption;
import access.manage.Manage;
import access.manage.ManageData;
import access.manage.PathUpdateType;
import access.manage.RequestType;
import access.model.Authority;
import access.model.ConnectionRequest;
import access.model.EntityType;
import access.model.Environment;
import access.model.Organization;
import access.model.OrganizationMembership;
import access.model.User;
import access.repository.OrganizationRepository;
import access.repository.UserRepository;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/idp"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
public class IdentityProviderController
implements UserAccessRights {
    private static final Log LOG = LogFactory.getLog(IdentityProviderController.class);
    private final UserRepository userRepository;
    private final OrganizationRepository organizationRepository;
    private final Manage manage;
    private final JiraClient jiraClient;
    private final MailBox mailBox;

    public IdentityProviderController(UserRepository userRepository, OrganizationRepository organizationRepository, Manage manage, JiraClient jiraClient, MailBox mailBox) {
        this.userRepository = userRepository;
        this.organizationRepository = organizationRepository;
        this.manage = manage;
        this.jiraClient = jiraClient;
        this.mailBox = mailBox;
    }

    @PutMapping(value={"/connect"})
    public ResponseEntity<Map<String, Object>> connect(User user, @RequestBody @Validated ConnectionRequest connectionRequest) {
        boolean connectWithoutInteraction;
        boolean memberRequest;
        String email = user.getEmail();
        LOG.debug((Object)("/connect SP to IdP connection for " + email));
        user = this.reinitializeUser(user, this.userRepository);
        String idpManageIdentifier = connectionRequest.getIdpManageIdentifier();
        Organization organization = (Organization)this.organizationRepository.findByManageIdentifier(idpManageIdentifier).orElseThrow(() -> new NotFoundException("Organization with manageIdentifier not found: " + idpManageIdentifier));
        Map serviceProvider = this.manage.providerById(connectionRequest.getEntityType(), connectionRequest.getApplicationManageIdentifier(), Environment.PROD);
        boolean bl = memberRequest = !user.isSuperUser();
        if (memberRequest) {
            OrganizationMembership organizationMembership = (OrganizationMembership)this.getOrganizationMembership(user, organization, Authority.GUEST).orElseThrow(() -> new NotAllowedException(String.format("User %s is not a member of organization %s", email, organization.getName())));
            boolean bl2 = memberRequest = !organizationMembership.getAuthority().equals((Object)Authority.ADMIN);
        }
        if (memberRequest) {
            ArrayList<User> admins = organization.getOrganizationMemberships().stream().filter(membership -> membership.getAuthority().equals((Object)Authority.ADMIN)).map(membership -> membership.getUser()).toList();
            if (admins.isEmpty()) {
                admins = this.userRepository.findBySuperUser(true);
            }
            String deeplink = String.format("/application-detail/%s/%s", serviceProvider.get("type"), serviceProvider.get("id"));
            admins = new ArrayList<User>(admins);
            admins.add(user);
            this.mailBox.sendConnectionRequest(user, admins, organization, ManageData.getProviderName((Map)serviceProvider), connectionRequest.getMessage(), deeplink);
            return Results.createResult();
        }
        Map identityProvider = this.manage.providerById(EntityType.saml20_idp, idpManageIdentifier, Environment.PROD);
        Map spMetaDataFields = ManageData.getMetaDataFields((Map)ManageData.getData((Map)serviceProvider));
        DashBoardConnectionOption connectOption = DashBoardConnectionOption.fromValue((String)spMetaDataFields.getOrDefault("coin:dashboard_connect_option", "connect_with_interaction"));
        String idpInstitutionGUID = (String)ManageData.getMetaDataFields((Map)ManageData.getData((Map)identityProvider)).get("coin:institution_guid");
        boolean idpAndSpShareInstitution = spMetaDataFields.getOrDefault("coin:institution_guid", "nope").equals(idpInstitutionGUID);
        boolean bl3 = connectWithoutInteraction = idpAndSpShareInstitution || !connectOption.equals((Object)DashBoardConnectionOption.connectWithInteraction);
        if (connectWithoutInteraction) {
            List recipients;
            this.manage.connectWithoutInteraction(identityProvider, serviceProvider, user);
            if (connectOption.equals((Object)DashBoardConnectionOption.connectWithoutInteractionWithEmail) && !CollectionUtils.isEmpty((Collection)(recipients = ManageData.contactPersons((Map)serviceProvider)))) {
                this.mailBox.sendNewConnectionCreated(user, recipients, ManageData.getProviderName((Map)identityProvider), ManageData.getProviderName((Map)serviceProvider), (String)ManageData.getData((Map)serviceProvider).get("entityid"));
            }
            return Results.createResult();
        }
        String changeRequestURL = this.manage.changeRequestURLConnectionRequest(EntityType.saml20_idp, idpManageIdentifier);
        String identityProviderEntityID = ManageData.getEntityID((Map)identityProvider);
        String serviceProviderEntityID = ManageData.getEntityID((Map)serviceProvider);
        String lineSeparator = System.lineSeparator();
        String summary = String.format("Connection request requested by %s for %s.", user.getName(), ManageData.getProviderName((Map)identityProvider));
        String jiraKey = this.jiraClient.create(new JiraIssue(serviceProviderEntityID, identityProviderEntityID, String.format("%s%sA change request in manage has been created to merge this user request. See:%s%s", summary, lineSeparator, lineSeparator, changeRequestURL), summary, EntityType.valueOf((String)((String)serviceProvider.get("type"))), email));
        ChangeRequest changeRequest = new ChangeRequest(idpManageIdentifier, EntityType.saml20_idp, Map.of("allowedEntities", Map.of("name", serviceProviderEntityID)), Map.of("user", email, "notes", String.format("Connection request requested by %s from %s for %s. See Jira %s", user.getName(), identityProviderEntityID, serviceProviderEntityID, jiraKey)), true, PathUpdateType.ADDITION, RequestType.LinkRequest, jiraKey);
        this.manage.createChangeRequest(Environment.PROD, changeRequest);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("status", HttpStatus.CREATED.value(), "jiraKey", jiraKey));
    }

    @PutMapping(value={"/disconnect"})
    public ResponseEntity<Map<String, Object>> disconnect(User user, @RequestBody @Validated ConnectionRequest connectionRequest) {
        LOG.debug((Object)("/disconnect SP to IdP request by " + user.getEmail()));
        user = this.reinitializeUser(user, this.userRepository);
        String idpManageIdentifier = connectionRequest.getIdpManageIdentifier();
        Organization organization = (Organization)this.organizationRepository.findByManageIdentifier(idpManageIdentifier).orElseThrow(() -> new NotFoundException("Organization with manageIdentifier not found: " + idpManageIdentifier));
        Map serviceProvider = this.manage.providerById(connectionRequest.getEntityType(), connectionRequest.getApplicationManageIdentifier(), Environment.PROD);
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        Map identityProvider = this.manage.providerById(EntityType.saml20_idp, idpManageIdentifier, Environment.PROD);
        String changeRequestURL = this.manage.changeRequestURLConnectionRequest(EntityType.saml20_idp, idpManageIdentifier);
        String identityProviderEntityID = ManageData.getEntityID((Map)identityProvider);
        String serviceProviderEntityID = ManageData.getEntityID((Map)serviceProvider);
        String lineSeparator = System.lineSeparator();
        String summary = String.format("Disconnection request requested by %s for %s.", user.getName(), ManageData.getProviderName((Map)identityProvider));
        String jiraKey = this.jiraClient.create(new JiraIssue(serviceProviderEntityID, identityProviderEntityID, String.format("%s%sA change request in manage has been created to merge this user request. See:%s%s", summary, lineSeparator, lineSeparator, changeRequestURL), summary, EntityType.valueOf((String)((String)serviceProvider.get("type"))), user.getEmail()));
        ChangeRequest changeRequest = new ChangeRequest(idpManageIdentifier, EntityType.saml20_idp, Map.of("allowedEntities", Map.of("name", serviceProviderEntityID)), Map.of("user", user.getEmail(), "notes", String.format("Disconnection request requested by %s from %s for %s. See Jira %s", user.getName(), identityProviderEntityID, serviceProviderEntityID, jiraKey)), true, PathUpdateType.REMOVAL, RequestType.UnlinkRequest, jiraKey);
        this.manage.createChangeRequest(Environment.PROD, changeRequest);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("status", HttpStatus.CREATED.value(), "jiraKey", jiraKey));
    }

    @PutMapping(value={"/cancel-connection-request"})
    public ResponseEntity<Map<String, Object>> cancelConnectionRequest(User user, @RequestBody @Validated ConnectionRequest connectionRequest) {
        LOG.debug((Object)("/cancelConnectionRequest SP to IdP request by " + user.getEmail()));
        user = this.reinitializeUser(user, this.userRepository);
        String idpManageIdentifier = connectionRequest.getIdpManageIdentifier();
        Organization organization = (Organization)this.organizationRepository.findByManageIdentifier(idpManageIdentifier).orElseThrow(() -> new NotFoundException("Organization with manageIdentifier not found: " + idpManageIdentifier));
        Map serviceProvider = this.manage.providerById(connectionRequest.getEntityType(), connectionRequest.getApplicationManageIdentifier(), Environment.PROD);
        this.confirmOrganizationMembership(user, organization, Authority.ADMIN);
        Map identityProvider = this.manage.providerById(EntityType.saml20_idp, idpManageIdentifier, Environment.PROD);
        List changeRequests = this.manage.getChangeRequestsIdentityProvider(identityProvider);
        String serviceProviderEntityID = ManageData.getEntityID((Map)serviceProvider);
        List<Map> openChangeRequests = changeRequests.stream().filter(changeRequest -> EntityType.saml20_idp.name().equals(changeRequest.get("type")) && PathUpdateType.ADDITION.name().equalsIgnoreCase((String)changeRequest.get("pathUpdateType")) && RequestType.LinkRequest.name().equalsIgnoreCase((String)changeRequest.get("requestType")) && serviceProviderEntityID.equals(changeRequest.getOrDefault("pathUpdates", Map.of()).getOrDefault("allowedEntities", Map.of()).get("name"))).toList();
        openChangeRequests.forEach(changeRequest -> this.manage.rejectChangeRequest(Environment.PROD, new ChangeRequest(changeRequest)));
        String comment = "Ticket can be closed by request of the requestor";
        openChangeRequests.forEach(changeRequest -> this.jiraClient.comment((String)changeRequest.get("ticketKey"), comment));
        return Results.okResult();
    }
}

